package net.bloom.bloomclient.utils.player

import net.bloom.bloomclient.features.module.modules.combat.ModuleAntiBot
import net.bloom.bloomclient.features.module.modules.other.ModuleTargets
import net.bloom.bloomclient.features.module.modules.other.ModuleTeams
import net.minecraft.client.MinecraftInstance
import net.minecraft.entity.Entity
import net.minecraft.entity.EntityLivingBase
import net.minecraft.entity.boss.EntityDragon
import net.minecraft.entity.item.EntityArmorStand
import net.minecraft.entity.monster.EntityGhast
import net.minecraft.entity.monster.EntityGolem
import net.minecraft.entity.monster.EntityMob
import net.minecraft.entity.monster.EntitySlime
import net.minecraft.entity.passive.EntityAnimal
import net.minecraft.entity.passive.EntityBat
import net.minecraft.entity.passive.EntitySquid
import net.minecraft.entity.passive.EntityVillager
import net.minecraft.entity.player.EntityPlayer


object EntityUtils: MinecraftInstance() {
    fun isSelected(entity: Entity, checkAttack: Boolean): Boolean {
        if (entity is EntityLivingBase) {
            if (entity is EntityArmorStand)
                return false

            if (!ModuleTargets.villagers.get() && entity is EntityVillager)
                return false

            if (!ModuleTargets.dead.get() && entity.isDead)
                return false

            if (!ModuleTargets.invisible.get() && entity.isInvisible())
                return false

            if (!ModuleTargets.mobs.get() && isMob(entity))
                return false

            if (!ModuleTargets.animals.get() && isAnimal(entity))
                return false

            if (!ModuleTargets.players.get() && entity is EntityPlayer)
                return false

            // TODO: friend

            if (checkAttack && !isEntityCanAttacked(entity))
                return false

            if (entity is EntityPlayer) {
                if (ModuleTeams.state && ModuleTeams.isInYourTeam(entity))
                    return false

                // TODO: AntiBot
                if (ModuleAntiBot.isBot(entity))
                    return false
            }
        }

        return entity != mc.thePlayer
    }

    fun isEntityCanAttacked(entity: EntityLivingBase): Boolean {
        if (entity.deathTime > 1)
            return false

        if (entity.ticksExisted < 1)
            return false

        return true
    }

    fun closestPerson(): EntityLivingBase? {
        val targets = mc.theWorld.loadedEntityList.filter {
            it is EntityLivingBase && it != mc.thePlayer && isSelected(it, true) && mc.thePlayer.canEntityBeSeen(it)
        }
        val entity = targets.minByOrNull { mc.thePlayer.getDistanceToEntity(it) }
        return entity as EntityLivingBase?
    }

    fun isAnimal(entity: Entity?): Boolean {
        return entity is EntityAnimal || entity is EntitySquid || entity is EntityGolem || entity is EntityBat
    }

    fun isMob(entity: Entity?): Boolean {
        return entity is EntityMob || entity is EntitySlime || entity is EntityGhast || entity is EntityDragon
    }

    fun isAlive(entity: EntityLivingBase) = entity.isEntityAlive && entity.health > 0

    fun isRendered(entity: Entity?): Boolean {
        return mc.theWorld != null && entity in mc.theWorld.loadedEntityList
    }

    // TODO: Conditions for friend check

}