package net.bloom.bloomclient.utils.io

import com.google.gson.Gson
import com.google.gson.GsonBuilder
import com.google.gson.JsonElement
import net.bloom.bloomclient.file.FileManager
import net.minecraft.client.MinecraftInstance
import java.awt.Font
import java.io.*
import java.nio.ByteBuffer
import java.nio.ByteOrder


object FileUtils: MinecraftInstance() {
    private val PRETTY_GSON: Gson = GsonBuilder().setPrettyPrinting().create()

    fun getFont(fontPath: String): Font {
        return try {
            val inputStream = File(FileManager.fontsFolder, fontPath).inputStream()
            val javaFont = Font.createFont(Font.TRUETYPE_FONT, inputStream).deriveFont(Font.PLAIN)
            inputStream.close()
            javaFont
        } catch (e: Exception) {
            e.printStackTrace()
            Font("default", Font.PLAIN, 12)
        }
    }

    fun getFontBuffer(fontPath: String): ByteBuffer {
        val inputStream = File(FileManager.fontsFolder, fontPath).inputStream()
        val fontBytes = inputStream.readBytes()

        val buffer = ByteBuffer.allocateDirect(fontBytes.size)
            .order(ByteOrder.nativeOrder())
            .put(fontBytes)

        buffer.flip()
        return buffer
    }

    fun writeJson(file: File, json: JsonElement) {
        val printWriter = PrintWriter(FileWriter(file))
        printWriter.println(PRETTY_GSON.toJson(json))
        printWriter.close()
    }

    fun readInputStream(inputStream: InputStream?): String {
        inputStream ?: return ""

        val stringBuilder = StringBuilder()
        try {
            val bufferedReader = BufferedReader(InputStreamReader(inputStream))
            var line: String?
            while (bufferedReader.readLine().also { line = it } != null) stringBuilder.append(line).append('\n')
        } catch (_: Exception) {}

        return stringBuilder.toString()
    }

    fun makeFolder(parent: File, path: String) = File(parent, path).also { if (!it.exists()) it.mkdirs() }

    fun writeLine(file: File, line: String) {
        file.parentFile?.mkdirs()
        FileWriter(file, true).use { fw ->
            BufferedWriter(fw).use { bw ->
                bw.write(line)
                bw.newLine()
            }
        }
    }
}