package net.bloom.bloomclient.utils.extension

import net.bloom.bloomclient.utils.player.RotationUtils.getFixedAngleDelta
import net.minecraft.client.gui.ScaledResolution
import net.minecraft.entity.Entity
import net.minecraft.util.BlockPos
import net.minecraft.util.Rotation
import net.minecraft.util.Vec3
import net.minecraft.util.Vec3i
import org.lwjgl.util.vector.Vector2f
import kotlin.math.roundToInt

/**
 * Provides:
 * ```
 * val (x, y, z) = blockPos
 */
operator fun Vec3i.component1() = x
operator fun Vec3i.component2() = y
operator fun Vec3i.component3() = z

operator fun BlockPos.component1() = x
operator fun BlockPos.component2() = y
operator fun BlockPos.component3() = z

/**
 * Provides:
 * ```
 * val (x, y, z) = vec
 */
operator fun Vec3.component1() = xCoord
operator fun Vec3.component2() = yCoord
operator fun Vec3.component3() = zCoord

/**
 * Provides:
 * ```
 * val (x, y) = vec
 */
operator fun Vector2f.component1() = x
operator fun Vector2f.component2() = y

operator fun BlockPos?.plus(n: Double): BlockPos? = this?.add(n, n, n)

/**
 * Provides:
 * ```
 * val (x, y, z) = mc.thePlayer
 */
operator fun Entity.component1() = posX
operator fun Entity.component2() = posY
operator fun Entity.component3() = posZ

/**
 * Provides:
 * ```
 * val (width, height) = ScaledResolution(mc)
 */
operator fun ScaledResolution.component1() = this.scaledWidth
operator fun ScaledResolution.component2() = this.scaledHeight

/**
 * Provides:
 * `vec + othervec`, `vec - othervec`, `vec * number`, `vec / number`, `-vec`
 * */
operator fun Vec3.plus(vec: Vec3): Vec3 = add(vec)
operator fun Vec3.minus(vec: Vec3): Vec3 = subtract(vec)
operator fun Vec3.times(number: Double) = Vec3(xCoord * number, yCoord * number, zCoord * number)
operator fun Vec3.div(number: Double) = times(1 / number)
operator fun Vec3.unaryMinus(): Vec3 = this.times(-1.0)

/**
 * Prevents possible NaN / (-) Infinity results.
 */
infix fun Int.safeDiv(b: Int) = if (b == 0) 0f else this.toFloat() / b.toFloat()
infix fun Int.safeDivI(b: Int) = if (b == 0) 0 else this / b
infix fun Int.safeDivD(b: Double) = if (b == 0.0) 0.0 else this / b

infix fun Float.safeDiv(b: Float) = if (b == 0f) 0f else this / b

fun Float.withGCD() = (this / getFixedAngleDelta()).roundToInt() * getFixedAngleDelta()
fun Double.withGCD() = (this / getFixedAngleDelta()).roundToInt() * getFixedAngleDelta()

fun Float.toRadians() = this * 0.017453292f
fun Double.toRadians() = this * 0.017453292
fun Double.toRadiansF() = toRadians().toFloat()
fun Double.toDegrees() = this * 57.295779513
fun Double.toDegreesF() = toDegrees().toFloat()

fun Rotation.lerpWith(other: Rotation, tickDelta: Number) =
    Rotation((yaw..other.yaw).lerpWith(tickDelta), (pitch..other.pitch).lerpWith(tickDelta))

fun IntRange.lerpWith(t: Float) = start + (endInclusive - start) * t

fun Int.lerpWith(other: Int, t: Float) = this + (other - this) * t