package net.bloom.bloomclient.utils.animations

import kotlin.math.*

enum class Easing(val easing: (Float) -> Float) {
    LINEAR({ it }),
    EASE_IN_QUAD({ it.pow(2) }),
    EASE_OUT_QUAD({ 1 - (1 - it) * (1 - it) }),
    EASE_IN_OUT_QUAD({ if (it < 0.5f) 2 * it.pow(2) else 1 - (-2 * it + 2).pow(2) / 2 }),
    EASE_IN_CUBIC({ it.pow(3) }),
    EASE_OUT_CUBIC({ 1 - (1 - it).pow(3) }),
    EASE_IN_OUT_CUBIC({ if (it < 0.5f) 4 * it.pow(3) else 1 - (-2 * it + 2).pow(3) / 2 }),
    EASE_IN_QUART({ it.pow(4) }),
    EASE_OUT_QUART({ 1 - (1 - it).pow(4) }),
    EASE_IN_OUT_QUART({ if (it < 0.5f) 8 * it.pow(4) else 1 - (-2 * it + 2).pow(4) / 2 }),
    EASE_IN_QUINT({ it.pow(5) }),
    EASE_OUT_QUINT({ 1 - (1 - it).pow(5) }),
    EASE_IN_OUT_QUINT({ if (it < 0.5f) 16 * it.pow(5) else 1 - (-2 * it + 2).pow(5) / 2 }),
    EASE_IN_SINE({ 1 - cos(it * PI / 2).toFloat() }),
    EASE_OUT_SINE({ sin(it * PI / 2).toFloat() }),
    EASE_IN_OUT_SINE({ (1 - cos(it * PI).toFloat()) / 2 }),
    EASE_IN_EXPO({ 2F.pow(10 * (it - 1)) }),
    EASE_OUT_EXPO({ 1 - 2F.pow(-10 * it) }),
    EASE_IN_OUT_EXPO({ if (it < 0.5f) 2F.pow(10 * (2 * it - 1)) / 2 else 1 - 2F.pow(-10 * (2 * it - 1)) / 2 }),
    EASE_IN_CIRC({ 1 - sqrt(1 - it.pow(2)) }),
    EASE_OUT_CIRC({ sqrt(1 - (it - 1).pow(2)) }),
    EASE_IN_OUT_CIRC({ if (it < 0.5f) (1 - sqrt(1 - (2 * it).pow(2))) / 2 else (sqrt(1 - (-2 * it + 2).pow(2)) + 1) / 2 }),
    SIGMOID({ 1 / (1 + exp(-it)) }),
    EASE_OUT_ELASTIC({ (1 - (cos(2 * it * PI * 7) * 0.5 + 0.5) * 2F.pow(-10 * it)).toFloat() }),
    EASE_IN_BACK({ it * it * (2.70158F * it - 1.70158F) }),
    EASE_OUT_BACK({ 1 + 2.70158F * (it - 1) * (it - 1) * (it - 1) + 1.70158F * (it - 1) }),
    EASE_IN_OUT_BACK({ if (it < 0.5f) 4 * it * it * (3 * it - 2) else 1 - (-2 * it + 2).pow(2) * (3 * -2 * it + 2) / 2 })
}
