package net.bloom.bloomclient.utils.animations

import net.bloom.bloomclient.utils.struct.MSTimer

class Animation(var easing: Easing, var duration: Long) {
    private val msTimer = MSTimer()

    var start = 0F
    var value = 0F
    var target = 0F
    var finished = false

    fun run(destination: Float) {
        if (target != destination) {
            target = destination
            reset()
        } else {
            finished = msTimer.hasTimePassed(duration)
            if (finished) {
                value = destination
                return
            }
        }

        val result = easing.easing(progress)

        value = if (value > destination) start - (start - destination) * result
        else start + (destination - start) * result
    }

    val progress
        get() = msTimer.reachedTime / duration.toFloat()

    fun reset() {
        msTimer.reset()
        start = value
        finished = false
    }
}