package net.bloom.bloomclient.utils.animations

object AnimHelper {

    /**
     * Smoothly animates a value towards a target
     * @param currentValue The current value
     * @param targetValue The target value to animate towards
     * @param speed The animation speed factor (higher = faster)
     * @return The new animated value
     */
    @JvmStatic
    fun animSmooth(currentValue: Float, targetValue: Float, speed: Float): Float {
        // Fixed implementation without relying on external dependencies
        return animate(targetValue, currentValue, speed * 0.025f)
    }

    /**
     * @author: longathelstan
     */
    private fun animate(target: Float, current: Float, speed: Float): Float {
        var current = current
        var diff = target - current
        val factor = speed.coerceIn(0.0f, 1.0f)

        if (diff > 0) {
            diff = diff.coerceAtLeast(0.0001f)
            current += diff * factor

            if (current > target) current = target
        } else if (diff < 0) {
            diff = diff.coerceAtMost(-0.0001f)
            current += diff * factor

            if (current < target) current = target
        }

        return current
    }

    /**
     * @author: longathelstan
     */

    private fun easeOut(aniTime: Float, totalAniTime: Float): Float {
        var aniTime = aniTime
        aniTime = aniTime / totalAniTime - 1.0f
        return aniTime * aniTime * aniTime + 1.0f
    }
}
