package net.bloom.bloomclient.utils

import kotlin.random.Random

object RandomUtils {

    fun nextInt(startInclusive: Int = 0, endExclusive: Int = Int.MAX_VALUE) =
        if (endExclusive - startInclusive <= 0) startInclusive else startInclusive + Random.nextInt(endExclusive - startInclusive)

    fun nextDouble(startInclusive: Double = 0.0, endInclusive: Double = 1.0) =
        if (startInclusive == endInclusive || endInclusive - startInclusive <= 0.0) startInclusive else startInclusive + (endInclusive - startInclusive) * Math.random()

    fun nextFloat(startInclusive: Float = 0f, endInclusive: Float = 1f) =
        if (startInclusive == endInclusive || endInclusive - startInclusive <= 0f) startInclusive else (startInclusive + (endInclusive - startInclusive) * Math.random()).toFloat()

    fun nextBoolean() = Random.nextBoolean()

    fun randomString(length: Int): String {
        return random(length, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz")
    }

    fun random(length: Int, chars: String): String {
        val stringBuilder = StringBuilder()
        for (i in 0 until length) stringBuilder.append(chars[java.util.Random().nextInt(chars.length)])
        return stringBuilder.toString()
    }
}