package net.bloom.bloomclient.utils

import com.google.gson.JsonObject
import net.bloom.bloomclient.BloomClient
import net.minecraft.client.MinecraftInstance
import net.minecraft.client.renderer.OpenGlHelper
import net.minecraft.src.Config
import net.minecraft.util.IChatComponent
import org.apache.logging.log4j.LogManager
import org.apache.logging.log4j.Logger
import kotlin.math.min


object ClientUtils: MinecraftInstance() {
    val LOGGER: Logger = LogManager.getLogger("BloomClient")

    fun displayChatMessage(message: String) {
        mc.thePlayer ?: run {
            LOGGER.info("(Minecraft Chat) $message")
            return
        }

        val jsonObject = JsonObject()
        jsonObject.addProperty("text", message)
        mc.thePlayer.addChatMessage(IChatComponent.Serializer.jsonToComponent(jsonObject.toString()))
    }

    fun displayChatMessage(message: Any) = displayChatMessage(message.toString())

    fun displaySystemMessage(message: Any) = displayChatMessage("[${BloomClient.CLIENT_NAME}] $message")

    fun getMaxDistanceByRam(): Int {
        if (OpenGlHelper.ati && !OpenGlHelper.vboSupported)
            return 16

        val memory = Runtime.getRuntime().maxMemory()

        return if (mc.isJava64bit && memory >= 1_000_000_000L) {
            if (memory >= 2_500_000_000L)
                64
            else if (memory >= 1_500_000_000L)
                48
            else
                32
        } else
            16
    }

    fun getDisplayModesCount(): Int {
        val displaymode = Config.getLargestDisplayMode()
        val widthFactor = displaymode.width / 320
        val heightFactor = displaymode.height / 240
        return min(widthFactor, heightFactor)
    }
}