package net.bloom.bloomclient.utils
import net.bloom.bloomclient.value.Value
import org.apache.logging.log4j.core.config.plugins.util.ResolverUtil
import java.lang.reflect.Modifier
import java.net.URI

object ClassUtils {

    fun getObjectInstance(clazz: Class<*>): Any {
        clazz.declaredFields.forEach {
            if (it.name.equals("INSTANCE")) {
                return it.get(null)
            }
        }
        throw IllegalAccessException("This class not a kotlin object")
    }

    private val cachedClasses = mutableMapOf<String, Boolean>()

    private fun hasClass(className: String): Boolean {
        return cachedClasses[className] ?: run {
            try {
                Class.forName(className)
                cachedClasses[className] = true
                true
            } catch (e: ClassNotFoundException) {
                cachedClasses[className] = false
                false
            }
        }
    }

    fun getValues(clazz: Class<*>, instance: Any) = clazz.declaredFields.map { valueField ->
        valueField.isAccessible = true
        valueField[instance]
    }.filterIsInstance<Value<*>>()

    fun <T : Any> resolvePackage(packagePath: String, klass: Class<T>): List<Class<out T>> {

        val resolver = ResolverUtil()

        resolver.classLoader = klass.classLoader

        resolver.findInPackage(object : ResolverUtil.Test {
            override fun matches(type: Class<*>?): Boolean = true

            override fun matches(resource: URI?): Boolean = false

            override fun doesMatchClass(): Boolean = true

            override fun doesMatchResource(): Boolean = false
        }, packagePath)

        val list = mutableListOf<Class<out T>>()

        for (resolved in resolver.classes) {
            resolved.declaredMethods.find {
                Modifier.isNative(it.modifiers)
            }?.let {
                val klass1 = it.declaringClass.typeName+"."+it.name
                throw UnsatisfiedLinkError(klass1+"\n\tat ${klass1}(Native Method)") // we don't want native methods
            }

            if (klass.isAssignableFrom(resolved) && !resolved.isInterface && !Modifier.isAbstract(resolved.modifiers)) {
                try {
                    list.add(resolved as Class<out T>) // Ensure type safety
                } catch (e: Exception) {
                    System.err.println("Failed to instantiate: ${resolved.name}, Error: ${e.message}")
                }
            }
        }

        return list
    }
}