package net.bloom.bloomclient.ui.hud.element.elements

import net.bloom.bloomclient.BloomClient
import net.bloom.bloomclient.ui.hud.element.Border
import net.bloom.bloomclient.ui.hud.element.Element
import net.bloom.bloomclient.ui.hud.element.ElementInfo
import net.bloom.bloomclient.utils.render.skiko.Skiko
import net.bloom.bloomclient.utils.render.skiko.SkikoContext
import net.bloom.bloomclient.utils.render.skiko.font.Fonts
import net.minecraft.client.gui.Side
import org.jetbrains.skia.*
import java.awt.Color

@ElementInfo(name = "Watermark")
class Watermark(
    x: Float = 0F,
    y: Float = 0F,
    scale: Float = 1F,
    side: Side = Side(Side.Horizontal.LEFT, Side.Vertical.TOP)
) : Element("Watermark", x, y, scale, side) {
    private val nunito = Fonts.NUNITO[10F]

    override fun drawElement(): Border {
        val text = "Bloom Client 1.0"
        val font = Fonts.NUNITO[10F]
        val metrics = font.metrics
        val textWidth = font.width(text)
        val textHeight = metrics.descent - metrics.ascent
        val hPad = 3f
        val vPad = 2f
        val baseX = renderX
        val baseY = renderY
        val x = when (side.horizontal) {
            Side.Horizontal.LEFT   -> baseX
            Side.Horizontal.MIDDLE -> baseX - (textWidth / 2) - hPad
            Side.Horizontal.RIGHT  -> baseX - textWidth - hPad * 2
        }
        val y = baseY
        val rect = Rect.makeLTRB(
            x,
            y,
            x + textWidth + hPad * 2,
            y + textHeight + vPad * 2
        )

        val rrect = RRect.makeLTRB(
            rect.left, rect.top, rect.right, rect.bottom,
            6f, 6f
        )
        val bgPaint = Paint().apply {
            color = Color(32, 34, 37, 220).rgb
            imageFilter = ImageFilter.makeDropShadow(0f, 1f, 6f, 6f, Color(0, 0, 0, 150).rgb)
        }
        val textPaint = Paint().apply {
            color = Color(255, 255, 255).rgb
        }
        SkikoContext.preFlush()
        val path = Path().apply { addRRect(rrect) }
        Skiko.drawPath(path, bgPaint)
        val baseline = rect.top + vPad - metrics.ascent
        font.text(
            text,
            x + hPad,
            baseline,
            textPaint
        )
        SkikoContext.flush()
        return Border(
            rect.left,
            rect.top,
            rect.right,
            rect.bottom
        )
    }

}
