package net.bloom.bloomclient.ui.hud.designer.panel

import net.bloom.bloomclient.font.Fonts
import net.bloom.bloomclient.ui.hud.HUD
import net.bloom.bloomclient.ui.hud.designer.GuiHUDDesigner
import net.bloom.bloomclient.ui.hud.element.Element
import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.render.RenderUtils
import net.bloom.bloomclient.value.values.*
import net.minecraft.client.gui.ScaledResolution
import net.minecraft.client.gui.Side
import net.minecraft.util.MathHelper
import org.lwjgl.input.Mouse
import java.awt.Color
import kotlin.math.max

class EditorPanel(val element: Element, x: Float, y: Float): DesignerPanel(x, y, 150, 200) {
    private val font = Fonts.fontConsolas[40]

    override fun drawPanel(mouseX: Int, mouseY: Int) {
        var yPos = 15 + scroll

        var panelWidth = 150

        for (value in element.values) {
            when (value) {
                is BoolValue -> panelWidth = max(panelWidth, font.getStringWidth(value.name))
                is FloatValue -> panelWidth = max(panelWidth, font.getStringWidth("${value.name}: §c${"%.2f".format(value.value)}"))
                is IntegerValue -> panelWidth = max(panelWidth, font.getStringWidth("${value.name}: §c${value.value}"))

                is ListValue -> {
                    panelWidth = max(panelWidth, font.getStringWidth(value.name))

                    // Selectable values
                    for (s in value.values) {
                        panelWidth = max(panelWidth, font.getStringWidth("§c> §r$s"))
                    }
                }
            }
        }

        if (panelWidth > width)
            width = panelWidth

        RenderUtils.drawRect(x, y + 12, x + panelWidth, y + height, color = Color(0, 0, 0, 150))

        // X
        font.drawString("X: ${"%.2f".format(element.renderX)} (${"%.2f".format(element.x)})", x + 2f, y + yPos, Color.WHITE)
        yPos += 10

        // Y
        font.drawString("Y: ${"%.2f".format(element.renderY)} (${"%.2f".format(element.y)})", x + 2f, y + yPos, Color.WHITE)
        yPos += 10

        // Scale
        font.drawString("Scale: ${"%.2f".format(element.scale)}", x + 2f, y + yPos, Color.WHITE)
        yPos += 10

        // Horizontal
        font.drawString("H:", x + 2f, y + yPos, Color.WHITE)
        font.drawString(element.side.horizontal.sideName, x + 16f, y + yPos, Color.GRAY)

        yPos += 10

        // Vertical
        font.drawString("V:", x + 2f, y + yPos, Color.WHITE)
        font.drawString(element.side.vertical.sideName, x + 16f, y + yPos, Color.GRAY)

        yPos += 10

        // Values
        for (value in element.values) {
            when (value) {
                is BoolValue -> {
                    font.drawString(value.name, x + 2f, y + yPos, if (value.get()) Color.WHITE else Color.GRAY)
                    yPos += 10
                }

                is FloatValue -> {
                    val current = value.get()
                    val min = value.minRange
                    val max = value.maxRange

                    // Title
                    val text = "${value.name}: §c${"%.2f".format(current)}"

                    font.drawString(text, x + 2f, y + yPos, Color.WHITE)
                    RenderUtils.drawRect(x + 8F, y + yPos + 12F, x + panelWidth - 8F, y + yPos + 13F, color = Color.WHITE)

                    // Slider mark
                    val sliderValue = x + ((panelWidth - 18F) * (current - min) / (max - min))
                    RenderUtils.drawRect(8F + sliderValue, y + yPos + 9F, sliderValue + 11F, y + yPos + 15F, color = Color(37, 126, 255))

                    // Slider changer
                    if (Mouse.isButtonDown(0) && MathUtils.isHover(mouseX, mouseY, x + 8, y + yPos + 9, x + panelWidth, y + yPos + 15)) {
                        val curr = MathHelper.clamp_float((mouseX - x - 8F) / (panelWidth - 18F), 0F, 1F)

                        value.set(min + (max - min) * curr)
                        element.updateElement()
                    }

                    // Change pos
                    yPos += 20
                }

                is IntegerValue -> {
                    val current = value.get()
                    val min = value.minRange
                    val max = value.maxRange

                    // Title
                    val text = "${value.name}: §c$current"

                    font.drawString(text, x + 2f, y + yPos, Color.WHITE)
                    // Slider
                    RenderUtils.drawRect(x + 8F, y + yPos + 12F, x + panelWidth - 8F, y + yPos + 13F, color = Color.WHITE)

                    // Slider mark
                    val sliderValue = x + (panelWidth - 18F) * (current - min) / (max - min)
                    RenderUtils.drawRect(
                        8F + sliderValue, y + yPos + 9F, sliderValue + 11F, y + yPos + 15F, color = Color(37, 126, 255)
                    )

                    // Slider changer
                    if (Mouse.isButtonDown(0) && MathUtils.isHover(mouseX, mouseY, x + 8, y + yPos + 9, x + panelWidth, y + yPos + 15)) {
                        val curr = MathHelper.clamp_float((mouseX - x - 8F) / (panelWidth - 18F), 0F, 1F)

                        value.set((min + (max - min) * curr).toInt())
                        element.updateElement()
                    }

                    // Change pos
                    yPos += 20
                }

                is ListValue -> {
                    // Title
                    font.drawString(value.name, x + 2f, y + yPos, Color.WHITE)

                    yPos += 10

                    // Selectable values
                    for (s in value.values) {
                        // Value title
                        val text = "§c> §r$s"
                        font.drawString(text, x + 2f, y + yPos, if (s == value.get()) Color.WHITE else Color.GRAY)
                        // Change pos
                        yPos += 10
                    }
                }

                // TODO: branch completion
                else -> {}
            }
        }

        // Header
        RenderUtils.drawRect(x, y, x + panelWidth, y + 12, color = Color(0, 160, 255))
        font.drawString("§l${element.name}", x + 2F, y + 3.5F, Color.WHITE)

        // Delete button
        val deleteWidth = x + panelWidth - font.getStringWidth("§lDelete") - 2
        font.drawString("§lDelete", deleteWidth, y + 3.5F, Color.WHITE)
    }

    override fun handleMouseClick(mouseX: Int, mouseY: Int, mouseButton: Int) {
        var yPos = scroll + 45

        if (MathUtils.isHover(mouseX, mouseY, x, y + yPos, x + width, y + yPos + 10)) {
            val values = Side.Horizontal.entries.toTypedArray()
            val currIndex = values.indexOf(element.side.horizontal)

            val x = element.renderX
            element.side.horizontal = values[(currIndex + 1) % values.size]
            val scaled = ScaledResolution(mc)

            element.x = when (element.side.horizontal) {
                Side.Horizontal.LEFT -> x
                Side.Horizontal.MIDDLE -> scaled.scaledWidth / 2 - x
                Side.Horizontal.RIGHT -> scaled.scaledWidth - x
            }
        }

        yPos += 10

        if (MathUtils.isHover(mouseX, mouseY, x, y + yPos, x + width, y + yPos + 10)) {
            val values = Side.Vertical.entries.toTypedArray()
            val currIndex = values.indexOf(element.side.vertical)
            val y = element.renderY
            val scaled = ScaledResolution(mc)

            element.side.vertical = values[(currIndex + 1) % values.size]
            element.y = when (element.side.vertical) {
                Side.Vertical.TOP -> y
                Side.Vertical.MIDDLE -> scaled.scaledHeight / 2 - y
                Side.Vertical.BOTTOM -> scaled.scaledHeight - y
            }

        }

        yPos += 10

        for (value in element.values) {
            when (value) {
                is BoolValue -> {
                    val stringWidth = font.getStringWidth(value.name)
                    if (MathUtils.isHover(mouseX, mouseY, x + 2, y + yPos, x + 2 + stringWidth, y + yPos + font.height)) {
                        value.set(!value.get())
                        element.updateElement()
                        return
                    }

                    // Change pos
                    yPos += 10
                }

                is IntegerValue, is FloatValue -> {
                    yPos += 20
                }

                is ListValue -> {
                    yPos += 10

                    // Selectable values
                    for (s in value.values) {
                        // Value title
                        val text = "§c> §r$s"

                        val stringWidth = font.getStringWidth(text)
                        if (MathUtils.isHover(mouseX, mouseY, x + 2, y + yPos, x + 2 + stringWidth, y + yPos + font.height)) {
                            value.set(s)
                            element.updateElement()
                            return
                        }
                        // Change pos
                        yPos += 10
                    }
                }

                // TODO: branch completion
                else -> {}
            }
        }

        val deleteWidth = x + width - font.getStringWidth("§lDelete") - 2
        if (MathUtils.isHover(mouseX, mouseY, deleteWidth, y, x + width, y + 10)) {
            HUD.removeElement(element)
            GuiHUDDesigner.currentPanel = GuiHUDDesigner.selectionPanel.also {
                it.x = x
                it.y = y
            }
        }
    }

}