/*package net.bloom.bloomclient.ui.clickgui.compact.renderers

import net.bloom.bloomclient.ui.clickgui.compact.GuiTheme
import net.bloom.bloomclient.ui.clickgui.tab.GuiAnimations
import net.bloom.bloomclient.ui.clickgui.compact.NewSTClickGUI
import net.bloom.bloomclient.ui.clickgui.compact.components.ValueRenderers
import net.bloom.bloomclient.utils.MathUtils
import org.lwjgl.input.Mouse

object SettingsPanel {
    fun render(module: Module, mouseX: Int, mouseY: Int) {
        val x = NewSTClickGUI.guiX + GuiTheme.CATEGORY_PANEL_WIDTH + GuiTheme.MODULE_PANEL_WIDTH + 1f
        val y = NewSTClickGUI.guiY + GuiTheme.TITLE_BAR_HEIGHT
        val w = GuiTheme.GUI_WIDTH - (GuiTheme.CATEGORY_PANEL_WIDTH + GuiTheme.MODULE_PANEL_WIDTH + 2f)
        val h = GuiTheme.GUI_HEIGHT - GuiTheme.TITLE_BAR_HEIGHT

        // Panel header
        drawPanelHeader(module, x, y, w)

        // If no settings, show message
        val values = module.displayableValues
        if (values.isEmpty()) {
            drawNoSettingsMessage(x, y, w)
            return
        }

        // Handle scrolling
        handleSettingsScroll(values, mouseX, mouseY, x, y, w, h)

        // Render settings
        NanoVGUtils.renderScissorBox(x, y + 22f, w, h - 22f) {
            renderSettings(values, mouseX, mouseY, x, y + 22f, w)
        }
    }

    private fun drawPanelHeader(module: Module, x: Float, y: Float, w: Float) {
        val headerBgColor = Color(
            GuiTheme.TITLE_BAR_COLOR.red,
            GuiTheme.TITLE_BAR_COLOR.green,
            GuiTheme.TITLE_BAR_COLOR.blue,
            100
        )

        NanoVGUtils.drawRect(x, y, w, 22f, headerBgColor)

        GuiTheme.settingHeaderFont.drawString(
            "${module.displayName} Settings",
            x + 10f,
            y + 5f,
            GuiTheme.TEXT_COLOR.rgb
        )
    }

    private fun drawNoSettingsMessage(x: Float, y: Float, w: Float) {
        val noSettingsY = y + 70f
        val noSettingsMessage = "No settings available"

        NanoVGUtils.drawRect(
            x + (w - GuiTheme.icon24Font.getStringWidth(GuiTheme.SETTINGS_ICON)) / 2f - 20f,
            noSettingsY - 10f,
            40f,
            40f,
            Color(GuiTheme.HIGHLIGHT_COLOR.red, GuiTheme.HIGHLIGHT_COLOR.green, GuiTheme.HIGHLIGHT_COLOR.blue, 120)
        )

        GuiTheme.icon24Font.drawString(
            GuiTheme.SETTINGS_ICON,
            x + (w - GuiTheme.icon24Font.getStringWidth(GuiTheme.SETTINGS_ICON)) / 2f,
            noSettingsY,
            GuiTheme.SUBTITLE_COLOR.rgb
        )

        GuiTheme.settingFont.drawString(
            noSettingsMessage,
            x + (w - GuiTheme.settingFont.getStringWidth(noSettingsMessage)) / 2f,
            noSettingsY + 40f,
            GuiTheme.SUBTITLE_COLOR.rgb
        )
    }

    private fun handleSettingsScroll(
        values: List<Any>, mouseX: Int, mouseY: Int,
        x: Float, y: Float, w: Float, h: Float
    ) {
        val contentY = y + 22f
        val contentHeight = h - 22f

        val totalValHeight = values.sumOf {
            when (it) {
                is ListValue -> if (GuiAnimations.listValueDropdownOpen.getOrDefault(it, false))
                    (it.values.size + 1) * GuiTheme.SETTING_ROW_HEIGHT + GuiTheme.SETTING_SPACING
                else
                    GuiTheme.SETTING_ROW_HEIGHT + GuiTheme.SETTING_SPACING
                else -> GuiTheme.SETTING_ROW_HEIGHT + GuiTheme.SETTING_SPACING
            }.toInt()
        }

        val minScroll = -(totalValHeight - contentHeight).coerceAtLeast(0f)
        val maxScroll = 0f

        if (MathUtils.isHover(mouseX, mouseY, x, contentY, x + w, y + h)) {
            val dWheel = Mouse.getDWheel() * 0.2f
            NewSTClickGUI.valueScroll = (NewSTClickGUI.valueScroll + dWheel).coerceIn(minScroll, maxScroll)
        }
    }

    private fun renderSettings(
        values: List<Any>, mouseX: Int, mouseY: Int,
        x: Float, y: Float, w: Float
    ) {
        var offsetY = 8f

        values.forEach { v ->
            val yPos = y + offsetY + NewSTClickGUI.valueScroll

            // Skip if not visible
            if (yPos + GuiTheme.SETTING_ROW_HEIGHT < y || yPos > y + GuiTheme.GUI_HEIGHT - y) {
                // Update offset without rendering
                offsetY += getValueHeight(v)
                return@forEach
            }

            // Background for setting row
            NanoVGUtils.drawRoundedRect(
                x + 8f, yPos, w - 16f, GuiTheme.SETTING_ROW_HEIGHT,
                4f, GuiTheme.HIGHLIGHT_COLOR
            )

            // Value name
            GuiTheme.settingFont.drawString(
                v.name,
                x + 14f,
                yPos + (GuiTheme.SETTING_ROW_HEIGHT */