/*package net.bloom.bloomclient.ui.clickgui.compact.renderers

import net.bloom.bloomclient.ui.clickgui.compact.GuiTheme
import net.bloom.bloomclient.ui.clickgui.tab.GuiAnimations
import net.bloom.bloomclient.ui.clickgui.compact.NewSTClickGUI
import net.bloom.bloomclient.utils.MathUtils
import org.lwjgl.input.Mouse

object ModulePanel {
    fun render(mouseX: Int, mouseY: Int) {
        val x = NewSTClickGUI.guiX + GuiTheme.CATEGORY_PANEL_WIDTH + 1f
        val y = NewSTClickGUI.guiY + GuiTheme.TITLE_BAR_HEIGHT
        val w = GuiTheme.MODULE_PANEL_WIDTH
        val h = GuiTheme.GUI_HEIGHT - GuiTheme.TITLE_BAR_HEIGHT

        // Draw panel header
        drawPanelHeader(x, y, w)

        // Handle scrolling and render modules
        handleModuleScroll(mouseX, mouseY, x, y, w, h)

        // Render modules
        NanoVGUtils.renderScissorBox(x, y + 22f, w, h - 22f) {
            renderModules(mouseX, mouseY, x, y + 22f, w)
        }
    }

    private fun drawPanelHeader(x: Float, y: Float, w: Float) {
        val headerBgColor = Color(
            GuiTheme.TITLE_BAR_COLOR.red,
            GuiTheme.TITLE_BAR_COLOR.green,
            GuiTheme.TITLE_BAR_COLOR.blue,
            100
        )

        NanoVGUtils.drawRect(x, y, w, 22f, headerBgColor)

        // Show category name or "Search Results"
        val headerText = if (NewSTClickGUI.searchActive && NewSTClickGUI.searchQuery.isNotEmpty()) {
            "Search Results"
        } else {
            getCategoryDisplayName(NewSTClickGUI.currentCategory)
        }

        GuiTheme.moduleFont.drawString(
            headerText,
            x + 10f,
            y + 6f,
            GuiTheme.TEXT_COLOR.rgb
        )
    }

    private fun handleModuleScroll(mouseX: Int, mouseY: Int, x: Float, y: Float, w: Float, h: Float) {
        val modules = getFilteredModules()
        val totalModHeight = modules.size * (GuiTheme.MODULE_ROW_HEIGHT + GuiTheme.MODULE_SPACING)
        val minScroll = -(totalModHeight - (h - 22f)).coerceAtLeast(0f)
        val maxScroll = 0f

        if (MathUtils.isHover(mouseX, mouseY, x, y + 22f, x + w, y + h)) {
            val dWheel = Mouse.getDWheel() * 0.2f
            NewSTClickGUI.moduleScroll = (NewSTClickGUI.moduleScroll + dWheel).coerceIn(minScroll, maxScroll)
        }
    }

    private fun renderModules(mouseX: Int, mouseY: Int, x: Float, y: Float, w: Float) {
        val modules = getFilteredModules()

        modules.forEachIndexed { i, mod ->
            val yPos = y + GuiTheme.MODULE_TOP_MARGIN +
                    NewSTClickGUI.moduleScroll +
                    i * (GuiTheme.MODULE_ROW_HEIGHT + GuiTheme.MODULE_SPACING)

            // Skip if not visible
            if (yPos + GuiTheme.MODULE_ROW_HEIGHT < y || yPos > y + GuiTheme.GUI_HEIGHT - y)
                return@forEachIndexed

            GuiAnimations.ensureModuleAnimationExists(mod)

            val hovered = MathUtils.isHover(mouseX, mouseY, x, yPos, x + w, yPos + GuiTheme.MODULE_ROW_HEIGHT)
            val selected = (mod == NewSTClickGUI.currentModule)

            renderModuleItem(mod, x, yPos, w, hovered, selected)
        }
    }

    private fun renderModuleItem(
        mod: Module, x: Float, yPos: Float, w: Float,
        hovered: Boolean, selected: Boolean
    ) {
        val stateAnim = GuiAnimations.moduleStateAnimations[mod]!!

        // Background
        val baseBgColor = when {
            selected -> GuiTheme.ACCENT_COLOR
            hovered -> GuiTheme.HOVER_COLOR
            else -> GuiTheme.HIGHLIGHT_COLOR
        }

        val bgColor = Color(
            baseBgColor.red,
            baseBgColor.green,
            baseBgColor.blue,
            if (selected) 60 else 40
        )

        NanoVGUtils.drawRoundedRect(x + 5f, yPos, w - 10f, GuiTheme.MODULE_ROW_HEIGHT, 4f, bgColor)

        // Active indicator
        if (stateAnim > 0) {
            NanoVGUtils.drawRoundedRect(
                x + 7f,
                yPos + 2f,
                4f,
                GuiTheme.MODULE_ROW_HEIGHT - 4f,
                2f,
                Color(
                    GuiTheme.BOOL_ON_COLOR.red,
                    GuiTheme.BOOL_ON_COLOR.green,
                    GuiTheme.BOOL_ON_COLOR.blue,
                    (255 * stateAnim).toInt()
                )
            )
        }

        // Module name with color transition
        val textColor = calculateModuleTextColor(stateAnim)

        GuiTheme.moduleFont.drawString(
            mod.displayName,
            x + 17f,
            yPos + (GuiTheme.MODULE_ROW_HEIGHT - GuiTheme.moduleFont.height) / 2f,
            textColor.rgb
        )

        // Settings indicator
        if (mod.displayableValues.isNotEmpty()) {
            val settingsIconColor = if (selected)
                GuiTheme.ACCENT_COLOR
            else
                Color(
                    GuiTheme.SUBTITLE_COLOR.red,
                    GuiTheme.SUBTITLE_COLOR.green,
                    GuiTheme.SUBTITLE_COLOR.blue,
                    (GuiTheme.SUBTITLE_COLOR.alpha * 0.7f).toInt()
                )

            GuiTheme.icon12Font.drawString(
                GuiTheme.SETTINGS_ICON,
                x + w - 25f,
                yPos + (GuiTheme.MODULE_ROW_HEIGHT - GuiTheme.icon12Font.height) / 2f,
                settingsIconColor.rgb
            )
        }
    }

    private fun calculateModuleTextColor(stateAnim: Float): Color {
        val r = GuiTheme.TEXT_COLOR.red +
                ((GuiTheme.BOOL_ON_COLOR.red - GuiTheme.TEXT_COLOR.red) * stateAnim).toInt()
        val g = GuiTheme.TEXT_COLOR.green +
                ((GuiTheme.BOOL_ON_COLOR.green - GuiTheme.TEXT_COLOR.green) * stateAnim).toInt()
        val b = GuiTheme.TEXT_COLOR.blue +
                ((GuiTheme.BOOL_ON_COLOR.blue - GuiTheme.TEXT_COLOR.blue) * stateAnim).toInt()

        return Color(r, g, b)
    }

    fun getFilteredModules(): List<Module> {
        val modules = BloomClient.moduleManager.modules

        return if (NewSTClickGUI.searchActive && NewSTClickGUI.searchQuery.isNotEmpty()) {
            modules.filter {
                it.displayName.lowercase().contains(NewSTClickGUI.searchQuery.lowercase())
            }.sortedBy { it.displayName }
        } else {
            modules.filter {
                it.category == NewSTClickGUI.currentCategory
            }.sortedBy { it.displayName }
        }
    }

    private fun getCategoryDisplayName(cat: ModuleCategory): String =
        cat.name.lowercase().replaceFirstChar { it.titlecase() }
}*/