/*package net.bloom.bloomclient.ui.clickgui.compact.renderers

import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.ui.clickgui.compact.GuiTheme
import net.bloom.bloomclient.ui.clickgui.tab.GuiAnimations
import net.bloom.bloomclient.ui.clickgui.compact.NewSTClickGUI
import net.bloom.bloomclient.ui.clickgui.tab.GuiTheme
import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.render.NanoVGUtils
import org.lwjgl.input.Mouse
import java.awt.Color
import kotlin.math.max
import kotlin.math.min

object CategoryPanel {
    fun render(mouseX: Int, mouseY: Int) {
        val x = NewSTClickGUI.guiX
        val y = NewSTClickGUI.guiY + GuiTheme.TITLE_BAR_HEIGHT + GuiTheme.CATEGORY_TOP_MARGIN
        val w = GuiTheme.CATEGORY_PANEL_WIDTH
        val h = GuiTheme.GUI_HEIGHT - GuiTheme.TITLE_BAR_HEIGHT - GuiTheme.CATEGORY_TOP_MARGIN
        val categories = ModuleCategory.values()

        // Handle scrolling
        handleScrolling(mouseX, mouseY, x, y, w, h)

        // Render categories
        NanoVGUtils.renderScissorBox(x, y, w, h) {
            renderCategoryItems(mouseX, mouseY, x, y, w)
        }
    }

    private fun handleScrolling(mouseX: Int, mouseY: Int, x: Float, y: Float, w: Float, h: Float) {
        val categories = ModuleCategory.values()
        val totalCatHeight = categories.size * (GuiTheme.MODULE_ROW_HEIGHT + GuiTheme.CAT_SPACING)
        val minScroll = -(totalCatHeight - h).coerceAtLeast(0f)
        val maxScroll = 0f

        if (MathUtils.isHover(mouseX, mouseY, x, y, x + w, y + h)) {
            val dWheel = Mouse.getDWheel() * 0.2f
            NewSTClickGUI.categoryScroll = (NewSTClickGUI.categoryScroll + dWheel).coerceIn(minScroll, maxScroll)
        }
    }

    private fun renderCategoryItems(mouseX: Int, mouseY: Int, x: Float, y: Float, w: Float) {
        val categories = ModuleCategory.values()

        categories.forEachIndexed { i, cat ->
            val yPos = y + NewSTClickGUI.categoryScroll + i * (GuiTheme.MODULE_ROW_HEIGHT + GuiTheme.CAT_SPACING)

            // Skip if not visible
            if (yPos + GuiTheme.MODULE_ROW_HEIGHT < y || yPos > y + GuiTheme.GUI_HEIGHT - GuiTheme.TITLE_BAR_HEIGHT)
                return@forEachIndexed

            // Ensure animation exists
            GuiAnimations.ensureCategoryAnimationExists(cat)

            // Calculate hover/selection state
            val hovered = MathUtils.isHover(mouseX, mouseY, x, yPos, x + w - 10f, yPos + GuiTheme.MODULE_ROW_HEIGHT)
            val active = (cat == NewSTClickGUI.currentCategory)

            // Update hover animation
            updateCategoryAnimation(cat, hovered, active)

            // Render category item
            renderCategoryItem(cat, x, yPos, w, hovered, active)
        }
    }

    private fun updateCategoryAnimation(cat: ModuleCategory, hovered: Boolean, active: Boolean) {
        if (hovered && !active) {
            GuiAnimations.categoryHoverAnimations[cat] = min(
                GuiAnimations.categoryHoverAnimations[cat]!! + 0.05f, 0.5f)
        } else if (!active) {
            GuiAnimations.categoryHoverAnimations[cat] = max(
                GuiAnimations.categoryHoverAnimations[cat]!! - 0.05f, 0f)
        } else {
            GuiAnimations.categoryHoverAnimations[cat] = min(
                GuiAnimations.categoryHoverAnimations[cat]!! + 0.05f, 1f)
        }
    }

    private fun renderCategoryItem(
        cat: ModuleCategory, x: Float, yPos: Float, w: Float,
        hovered: Boolean, active: Boolean
    ) {
        val animValue = GuiAnimations.categoryHoverAnimations[cat]!!

        // Background
        val bgColor = calculateCategoryBgColor(cat, active, animValue)
        NanoVGUtils.drawRoundedRect(x + 6f, yPos, w - 12f, GuiTheme.MODULE_ROW_HEIGHT, 8f, bgColor)

        // Icon
        val iconColor = if (active) GuiTheme.ACCENT_COLOR else GuiTheme.TEXT_COLOR
        val iconStr = getCategoryIcon(cat)
        GuiTheme.icon12Font.drawString(
            iconStr,
            x + 16f,
            yPos + (GuiTheme.MODULE_ROW_HEIGHT - GuiTheme.icon12Font.height) / 2f,
            iconColor.rgb
        )

        // Label
        val iconWidth = GuiTheme.icon12Font.getStringWidth(iconStr)
        val displayName = getCategoryDisplayName(cat)

        GuiTheme.categoryFont.drawString(
            displayName,
            x + 16f + iconWidth + 8f,
            yPos + (GuiTheme.MODULE_ROW_HEIGHT - GuiTheme.categoryFont.height) / 2f + 0.5f,
            if (active) GuiTheme.ACCENT_COLOR.rgb else GuiTheme.TEXT_COLOR.rgb
        )

        // Active indicator
        if (active) {
            NanoVGUtils.drawRoundedRect(
                x + 7f,
                yPos + 2f,
                4f,
                GuiTheme.MODULE_ROW_HEIGHT - 4f,
                8f,
                GuiTheme.ACCENT_COLOR
            )
        }
    }

    private fun calculateCategoryBgColor(cat: ModuleCategory, active: Boolean, animValue: Float): Color {
        return if (active) {
            Color(
                GuiTheme.ACCENT_COLOR.red,
                GuiTheme.ACCENT_COLOR.green,
                GuiTheme.ACCENT_COLOR.blue,
                (60 + 40 * animValue).toInt()
            )
        } else if (animValue > 0) {
            Color(
                GuiTheme.HIGHLIGHT_COLOR.red,
                GuiTheme.HIGHLIGHT_COLOR.green,
                GuiTheme.HIGHLIGHT_COLOR.blue,
                (100 * animValue).toInt()
            )
        } else {
            GuiTheme.TRANSPARENT
        }
    }

    private fun getCategoryDisplayName(cat: ModuleCategory): String =
        cat.name.lowercase().replaceFirstChar { it.titlecase() }

    private fun getCategoryIcon(cat: ModuleCategory): String = when (cat) {
        ModuleCategory.COMBAT   -> GuiTheme.COMBAT_ICON
        ModuleCategory.MOVEMENT -> GuiTheme.MOVE_ICON
        ModuleCategory.PLAYER   -> GuiTheme.USER_ICON
        ModuleCategory.RENDER   -> GuiTheme.EYE_ICON
        ModuleCategory.CLIENT   -> GuiTheme.BLOOM_ICON
        else                    -> GuiTheme.PUZZLE_ICON
    }
}*/