package net.bloom.bloomclient.ui.clickgui.tab

import net.bloom.bloomclient.BloomClient
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.ui.clickgui.compact.NewSTClickGUI
import net.bloom.bloomclient.value.values.*
import kotlin.math.max
import kotlin.math.min

object GuiAnimations {
    // Animation maps
    val moduleStateAnimations = mutableMapOf<Module, Float>()
    val categoryHoverAnimations = mutableMapOf<ModuleCategory, Float>()
    val sliderHandleAnimations = mutableMapOf<Any, Float>()
    val booleanValueAnimations = mutableMapOf<BoolValue, Float>()

    // For list values
    val listValueDropdownOpen = mutableMapOf<ListValue, Boolean>()
    val listValueClickMap = mutableMapOf<ListValue, Boolean>()

    // Dragging state
    var draggingSliderValue: Any? = null

    // Initialize animations for a module
    fun ensureModuleAnimationExists(module: Module) {
        if (!moduleStateAnimations.containsKey(module)) {
            moduleStateAnimations[module] = if (module.state) 1f else 0f
        }
    }

    // Initialize category animation
    fun ensureCategoryAnimationExists(category: ModuleCategory) {
        if (!categoryHoverAnimations.containsKey(category)) {
            categoryHoverAnimations[category] = if (category == NewSTClickGUI.currentCategory) 1f else 0f
        }
    }

    // Initialize boolean animation
    fun ensureBoolAnimationExists(value: BoolValue) {
        if (!booleanValueAnimations.containsKey(value)) {
            booleanValueAnimations[value] = if (value.value) 1f else 0f
        }
    }

    // Update all animations
    fun updateAnimations() {
        // Update module animations
        BloomClient.moduleManager.modules.forEach { mod ->
            ensureModuleAnimationExists(mod)
            if (mod.state) {
                moduleStateAnimations[mod] = min(moduleStateAnimations[mod]!! + 0.05f, 1f)
            } else {
                moduleStateAnimations[mod] = max(moduleStateAnimations[mod]!! - 0.05f, 0f)
            }
        }

        // Update boolean animations
        booleanValueAnimations.forEach { (value, _) ->
            if (value.value) {
                booleanValueAnimations[value] = min(booleanValueAnimations[value]!! + 0.05f, 1f)
            } else {
                booleanValueAnimations[value] = max(booleanValueAnimations[value]!! - 0.05f, 0f)
            }
        }
    }

    // Animation utility functions
    fun easeOut(t: Float): Float = 1f - (1f - t) * (1f - t)

    fun elasticOut(t: Float): Float {
        val p = 0.3f
        return Math.pow(2.0, -10.0 * t).toFloat() *
                Math.sin((t - p / 4) * (2 * Math.PI) / p).toFloat() + 1
    }
}