package net.bloom.bloomclient.ui.clickgui.augustus.values

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.value.values.ModeValue
import java.awt.Color

class AugustusModeValueComponent(value: ModeValue<*>): AbstractAugustusValueComponent<ModeValue<*>>(value) {
    private val modeStrings = value.modes.map { it.name }

    override fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float {
        var listValueStartX = x + valueNameStringWidth
        var valueY = 0f

        for ((index, element) in modeStrings.withIndex()) {
            val stringWidth = font.getStringWidth(element)
            val stringColor = if (element.equals(value.value.name, true)) Color(252, 186, 3) else Color(200, 200, 200)

            if (listValueStartX + stringWidth > x2 - 8) {
                listValueStartX = x + valueNameStringWidth
                valueY += font.height + 5
            }

            font.drawString(element, listValueStartX, y + valueY, stringColor.rgb)

            listValueStartX += stringWidth

            if (index != modeStrings.size - 1) {
                font.drawString(", ", listValueStartX, y + valueY, Color(200, 200, 200).rgb)
                listValueStartX += font.getStringWidth(", ")
            }
        }

        valueY += font.height + 5

        val filteredComponents = value.value.augustusComponents.filter { it.value.canDisplay() }
        for (component in filteredComponents) {
            component.drawValueName(x, y + valueY)
            valueY += component.drawValue(mouseX, mouseY, x, y + valueY, x2, y2 - 6)
        }

        return valueY
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long): Float {
        var listValueStartX = x + valueNameStringWidth
        var valueY = 0f

        for ((index, element) in modeStrings.withIndex()) {
            val stringWidth = font.getStringWidth(element)

            if (listValueStartX + stringWidth > x2 - 8) {
                listValueStartX = x + valueNameStringWidth
                valueY += font.height + 5
            }

            listValueStartX += stringWidth

            if (index != modeStrings.size - 1)
                listValueStartX += font.getStringWidth(", ")
        }

        valueY += font.height + 5

        val filteredComponents = value.value.augustusComponents.filter { it.value.canDisplay() }
        for (component in filteredComponents) {
            val incHeight = component.mouseClickMove(mouseX, mouseY, x, y + valueY, x2, y2, clickedMouseButton, timeSinceLastClick)
            if (incHeight == 0f)
                return 0f

            valueY += incHeight
        }

        return valueY
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int): Float {
        var listValueStartX = x + valueNameStringWidth
        var valueY = 0f

        for ((index, element) in modeStrings.withIndex()) {
            val stringWidth = font.getStringWidth(element)

            if (listValueStartX + stringWidth > x2 - 8) {
                listValueStartX = x + valueNameStringWidth
                valueY += font.height + 5
            }

            if (MathUtils.isHover(mouseX, mouseY, listValueStartX - 2, y + valueY - 4, listValueStartX + stringWidth + 2, y + valueY + font.height) && mouseButton == 0) {
                value.setValue(element)
                break
            }

            listValueStartX += stringWidth

            if (index != modeStrings.size - 1)
                listValueStartX += font.getStringWidth(", ")
        }

        valueY += font.height + 5

        val filteredComponents = value.value.augustusComponents.filter { it.value.canDisplay() }
        for (component in filteredComponents) {
            val incHeight = component.mouseClicked(mouseX, mouseY, x, y + valueY, x2, y2, mouseButton)

            if (incHeight == 0f)
                return 0f

            valueY += incHeight
        }

        return valueY
    }

    override fun mouseReleased(mouseX: Int, mouseY: Int, state: Int) {
        value.value.augustusComponents.forEach { it.mouseReleased(mouseX, mouseY, state) }
    }
}