package net.bloom.bloomclient.ui.clickgui.augustus.values

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.render.RenderUtils
import net.bloom.bloomclient.value.values.IntegerValue
import java.awt.Color
import kotlin.math.round

class AugustusIntegerValueComponent(value: IntegerValue): AbstractAugustusValueComponent<IntegerValue>(value) {
    private val sliderWidth = 120

    override fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float {
        val minRange = value.minRange

        val slideStartX = x + valueNameStringWidth
        val valueWidth = (value.value - minRange) * sliderWidth / value.deltaRange
        val valueStringWidth = font.getStringWidth(value.value.toString())

        RenderUtils.drawBorderRect(slideStartX - 1, y - 3, slideStartX + sliderWidth + 1, y + font.height - 1, Color(220, 220, 220), 1f)
        RenderUtils.drawRect(slideStartX, y - 2, slideStartX + valueWidth, y + font.height - 2, color = Color.BLUE)
        font.drawString(value.value.toString(), slideStartX + (sliderWidth - valueStringWidth) / 2, y + 1, Color(200, 200, 200).rgb)

        return font.height + 5f
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int): Float {
        return font.height + 5f
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long): Float {
        val minRange = value.minRange
        val maxRange = value.maxRange
        val slideStartX = x + valueNameStringWidth

        if (MathUtils.isHover(mouseX, mouseY, slideStartX - 5, y - 3, slideStartX + sliderWidth + 5, y + font.height - 1)) {
            val newValue = minRange + (mouseX - slideStartX) * value.deltaRange / sliderWidth
            value.set(round(newValue).toInt().coerceIn(minRange, maxRange))
            return 0f
        }

        return font.height + 5f
    }
}