package net.bloom.bloomclient.ui.clickgui.augustus.values

import net.bloom.bloomclient.ui.clickgui.augustus.AugustusClickGUI
import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.value.values.GroupValue
import java.awt.Color

class AugustusGroupValueComponent(value: GroupValue, private var marginLeft: Float = 8f): AbstractAugustusValueComponent<GroupValue>(value) {
    val components = value.value.mapNotNull {
        AugustusClickGUI.getAugustusComponent(it).also { component ->
            if (component is AugustusGroupValueComponent) component.marginLeft = this.marginLeft + 8f
        }
    }.toList()

    override fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float {
        var valueY = font.height + 5f
        if (value.isListOpen) {
            val filteredComponents = components.filter { it.value.canDisplay() }
            for (component in filteredComponents) {
                component.drawValueName(x + marginLeft, y + valueY)
                valueY += component.drawValue(mouseX, mouseY, x + marginLeft, y + valueY, x2, y2 - 6)
            }
        }

        return valueY
    }

    override fun drawValueName(x: Float, y: Float) {
        val stringState = if (value.isListOpen) "▼" else "▶"
        font.drawString("$stringState ${value.name}", x, y, Color(200, 200, 200).rgb)
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long): Float {
        var valueY = font.height + 5f

        if (value.isListOpen) {
            val filteredComponents = components.filter { it.value.canDisplay() }
            for (component in filteredComponents) {
                val incHeight = component.mouseClickMove(mouseX, mouseY, x + marginLeft, y + valueY, x2, y2, clickedMouseButton, timeSinceLastClick)
                if (incHeight == 0f)
                    return 0f

                valueY += incHeight
            }
        }

        return valueY
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int): Float {
        val stringState = if (value.isListOpen) "▼" else "▶"
        val stringWidth = font.getStringWidth("$stringState ${value.name}")

        if (MathUtils.isHover(mouseX, mouseY, x, y, x + stringWidth, y + font.height)) {
            value.isListOpen = !value.isListOpen
            return 0f
        }

        var valueY = font.height + 5f
        if (value.isListOpen) {
            val filteredComponents = components.filter { it.value.canDisplay() }
            for (component in filteredComponents) {
                val incHeight = component.mouseClicked(mouseX, mouseY, x + marginLeft, y + valueY, x2, y2, mouseButton)

                if (incHeight == 0f)
                    return 0f

                valueY += incHeight
            }
        }

        return valueY
    }

    override fun mouseReleased(mouseX: Int, mouseY: Int, state: Int) {
        for (component in components)
            component.mouseReleased(mouseX, mouseY, state)
    }
}