package net.bloom.bloomclient.ui.clickgui.augustus.values

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.render.RenderUtils
import net.bloom.bloomclient.value.RangeSlider
import net.bloom.bloomclient.value.values.FloatRangeValue
import java.awt.Color
import kotlin.math.abs

class AugustusFloatRangeValueComponent(value: FloatRangeValue): AbstractAugustusValueComponent<FloatRangeValue>(value) {
    private var currentSlider = RangeSlider.NONE
    private val sliderWidth = 106

    override fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float {
        val minRange = value.minRange
        val slideStartX = x + valueNameStringWidth

        val minValue = value.value.minimum
        val maxValue = value.value.maximum

        val minValueWidth = (minValue - minRange) * (sliderWidth - 6) / value.deltaRange
        val maxValueWidth = (maxValue - minRange) * (sliderWidth - 6) / value.deltaRange

        val minValueRounded = MathUtils.round(minValue, 2)
        val maxValueRounded = MathUtils.round(maxValue, 2)
        val valueString = "$minValueRounded - $maxValueRounded"
        val valueStringWidth = font.getStringWidth(valueString)

        RenderUtils.drawBorderRect(slideStartX - 1, y - 3, slideStartX + sliderWidth + 1, y + font.height - 1, Color(220, 220, 220), 1f)
        RenderUtils.drawRect(slideStartX + minValueWidth, y - 2, slideStartX + maxValueWidth + 6, y + font.height - 2, color = Color.BLUE)

        font.drawString(valueString, slideStartX + (sliderWidth - valueStringWidth) / 2, y + 1, Color(200, 200, 200).rgb)

        return font.height + 5f
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long): Float {
        val minRange = value.minRange
        val maxRange = value.maxRange

        val sliderWidth = 106
        val slideStartX = x + valueNameStringWidth

        val minValue = value.value.minimum
        val maxValue = value.value.maximum

        val minValueWidth = (minValue - minRange) * (sliderWidth - 6) / value.deltaRange
        val maxValueWidth = (maxValue - minRange) * (sliderWidth - 6) / value.deltaRange

        if (MathUtils.isHover(mouseX, mouseY, slideStartX - 5, y - 3, slideStartX + sliderWidth + 5, y + font.height - 1)) {
            val leftSliderPos = slideStartX + minValueWidth
            val rightSliderPos = slideStartX + maxValueWidth + 6

            val distToSlider1 = mouseX - leftSliderPos
            val distToSlider2 = mouseX - rightSliderPos

            val closerToLeft = abs(distToSlider1) < abs(distToSlider2)

            val isOnLeftSlider = (mouseX > slideStartX && mouseX < leftSliderPos || closerToLeft) && rightSliderPos > slideStartX - 5
            val isOnRightSlider = (mouseX > rightSliderPos && mouseX < slideStartX + sliderWidth + 5 || !closerToLeft) && leftSliderPos < slideStartX + sliderWidth + 5

            if (isOnLeftSlider && currentSlider == RangeSlider.NONE || currentSlider == RangeSlider.LEFT) {
                val newValue = minRange + (mouseX - slideStartX) / (sliderWidth - 6) * value.deltaRange
                value.value.minimum = MathUtils.round(newValue, 2).toFloat().coerceIn(minRange, maxValue)
            }

            if (isOnRightSlider && currentSlider == RangeSlider.NONE || currentSlider == RangeSlider.RIGHT) {
                val newValue = minRange + (mouseX - 6 - slideStartX) / (sliderWidth - 6) * value.deltaRange
                value.value.maximum = MathUtils.round(newValue, 2).toFloat().coerceIn(minValue, maxRange)
            }

            if (currentSlider != RangeSlider.NONE) {
                if (isOnLeftSlider) currentSlider = RangeSlider.LEFT
                else if (isOnRightSlider) currentSlider = RangeSlider.RIGHT
            }
        }

        return font.height + 5f
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int): Float {
        return font.height + 5f
    }

    override fun mouseReleased(mouseX: Int, mouseY: Int, state: Int) {
        currentSlider = RangeSlider.NONE
    }
}