package net.bloom.bloomclient.ui.clickgui.augustus.values

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.value.values.EnumValue
import java.awt.Color

class AugustusEnumValueComponent(value: EnumValue<*>): AbstractAugustusValueComponent<EnumValue<*>>(value) {
    override fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float {
        var listValueStartX = x + valueNameStringWidth
        var totalListValueY = 0f

        for ((index, element) in value.values.withIndex()) {
            val stringWidth = font.getStringWidth(element.name)
            val stringColor = if (element == value.value) Color(252, 186, 3) else Color(200, 200, 200)

            if (listValueStartX + stringWidth > x2 - 8) {
                listValueStartX = x + valueNameStringWidth
                totalListValueY += font.height + 5
            }

            font.drawString(element.name, listValueStartX, y + totalListValueY, stringColor.rgb)

            listValueStartX += stringWidth

            if (index != value.values.size - 1) {
                font.drawString(", ", listValueStartX, y + totalListValueY, Color(200, 200, 200).rgb)
                listValueStartX += font.getStringWidth(", ")
            }
        }

        return totalListValueY + font.height + 5
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long): Float {
        var listValueStartX = x + valueNameStringWidth
        var totalListValueY = 0f

        for ((index, element) in value.values.withIndex()) {
            val stringWidth = font.getStringWidth(element.name)

            if (listValueStartX + stringWidth > x2 - 8) {
                listValueStartX = x + valueNameStringWidth
                totalListValueY += font.height + 5
            }

            listValueStartX += stringWidth

            if (index != value.values.size - 1)
                listValueStartX += font.getStringWidth(", ")
        }

        return totalListValueY + font.height + 5f
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int): Float {
        var listValueStartX = x + valueNameStringWidth
        var totalListValueY = 0f

        for ((index, element) in value.values.withIndex()) {
            val stringWidth = font.getStringWidth(element.name)

            if (listValueStartX + stringWidth > x2 - 8) {
                listValueStartX = x + valueNameStringWidth
                totalListValueY += font.height + 5
            }

            if (MathUtils.isHover(mouseX, mouseY, listValueStartX - 2, y + totalListValueY - 4, listValueStartX + stringWidth + 2, y + totalListValueY + font.height) && mouseButton == 0) {
                value.setValue(element.name)
                return 0f
            }

            listValueStartX += stringWidth

            if (index != value.values.size - 1)
                listValueStartX += font.getStringWidth(", ")
        }

        return totalListValueY + font.height + 5f
    }
}