package net.bloom.bloomclient.ui.clickgui.augustus.values

import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.value.values.BoolValue
import java.awt.Color

class AugustusBoolValueComponent(value: BoolValue): AbstractAugustusValueComponent<BoolValue>(value) {
    override fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float {
        val stringState = if (value.value) "true" else "false"
        val stringStateX = x + valueNameStringWidth
        val stringColor = if (value.value) Color(0, 255, 0, 200) else Color(255, 0, 0, 200)
        font.drawString(stringState, stringStateX, y, stringColor.rgb)

        return font.height + 5f
    }

    override fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long): Float {
        return font.height + 5f
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int): Float {
        val stringState = if (value.value) "§atrue" else "§cfalse"
        val stringStateStartX = x + valueNameStringWidth - 2
        val stringStateStartY = y - 3
        val stringStateEndX = stringStateStartX + font.getStringWidth(stringState) + 2
        val stringStateEndY = y + font.height + 3

        if (MathUtils.isHover(mouseX, mouseY, stringStateStartX, stringStateStartY, stringStateEndX, stringStateEndY) && mouseButton == 0) {
            value.set(!value.value)
            return 0f
        }

        return font.height + 5f
    }
}