package net.bloom.bloomclient.ui.clickgui.augustus.values

import net.bloom.bloomclient.font.Fonts
import net.bloom.bloomclient.value.Value
import net.minecraft.client.MinecraftInstance
import java.awt.Color

abstract class AbstractAugustusValueComponent<T: Value<*>>(val value: T): MinecraftInstance() {
    protected val font = Fonts.fontConsolas[40]
    val valueNameStringWidth = font.getStringWidth("${value.name}: ")

    open fun drawValueName(x: Float, y: Float) {
        font.drawString("${value.name}: ", x, y, Color(200, 200, 200).rgb)
    }

    abstract fun drawValue(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float): Float

    abstract fun mouseClickMove(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, clickedMouseButton: Int, timeSinceLastClick: Long): Float

    abstract fun mouseClicked(mouseX: Int, mouseY: Int, x: Float, y: Float, x2: Float, y2: Float, mouseButton: Int): Float

    open fun mouseReleased(mouseX: Int, mouseY: Int, state: Int) {}

}