package net.bloom.bloomclient.ui.clickgui.augustus

import net.bloom.bloomclient.BloomClient
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.modules.other.ModuleClickGUI
import net.bloom.bloomclient.file.Configurable
import net.bloom.bloomclient.file.FileManager
import net.bloom.bloomclient.font.Fonts
import net.bloom.bloomclient.ui.clickgui.augustus.values.*
import net.bloom.bloomclient.utils.MathUtils
import net.bloom.bloomclient.utils.render.RenderUtils
import net.bloom.bloomclient.value.Value
import net.bloom.bloomclient.value.values.*
import net.minecraft.client.gui.GuiScreen
import org.lwjgl.input.Mouse
import java.awt.Color

object AugustusClickGUI: GuiScreen() {
	private val clickGuiStartX = 50f
	private val clickGuiStartY = 20f

	private val clickGuiWidth = 600
	private val clickGuiHeight = 350

	private var deltaWheelModule = 0f
	private var deltaWheelValue = 0f
	private var isHoverOnSlide = false

	private val fontConsolas = Fonts.fontConsolas[40]

	private var currentCategory = ModuleCategory.RENDER
		set(value) {
			field = value
			deltaWheelModule = 0f
		}

	private var currentModule: Module? = ModuleClickGUI
		set(value) {
			field = value
			deltaWheelValue = 0f
		}

	override fun initGui() {}

	override fun drawScreen(mouseX: Int, mouseY: Int, partialTicks: Float) {
		val endX = clickGuiStartX + clickGuiWidth
		val endY = clickGuiStartY + clickGuiHeight

		val titleHeight = Fonts.fontESP[64].height + 10

		RenderUtils.drawRoundedRect(clickGuiStartX, clickGuiStartY, endX, endY, 5f, Color(25, 25, 25, 180))
		RenderUtils.drawRect(clickGuiStartX, clickGuiStartY, endX, clickGuiStartY + titleHeight, 5f, Color(20, 20, 20),
			roundTL = true,
			roundTR = true
		)
		Fonts.fontESP[64].drawString("CLICKGUI", clickGuiStartX + 5, clickGuiStartY + 5, Color(200, 200, 200).rgb)
		
		val categoryPanelPosY = clickGuiStartY + titleHeight + 10
		val categoryPanelPosX = clickGuiStartX + 130
		val categoryPanelPosEndY = categoryPanelPosY + fontConsolas.height + 1
		var categoryPos = 0f

		for (category in ModuleCategory.entries) {
			val stringWidth = fontConsolas.getStringWidth(category.toString())
			val categoryStartPos = categoryPanelPosX + categoryPos
			fontConsolas.drawString(category.toString(), categoryStartPos, categoryPanelPosY, Color(200, 200, 200).rgb)

			if (category == currentCategory)
				RenderUtils.drawRect(categoryStartPos, categoryPanelPosEndY, categoryStartPos + stringWidth, categoryPanelPosEndY + 1, color = Color(200, 200, 200))

			categoryPos += stringWidth + 15f
		}

		RenderUtils.drawRect(clickGuiStartX + 110, categoryPanelPosEndY + 8, endX, categoryPanelPosEndY + 10, color = Color(20, 20, 20))

		val filteredModules = BloomClient.moduleManager.modules.filter { it.category == currentCategory }
		val modulePanelStartY = clickGuiStartY + titleHeight + 5
		val moduleItemHeight = fontConsolas.height + 5
	    val moduleMaxScroll = -(filteredModules.size * moduleItemHeight - endY + modulePanelStartY + 6).coerceAtLeast(0f)

	    val wheel = Mouse.getDWheel()

	    if (MathUtils.isHover(mouseX, mouseY, clickGuiStartX, modulePanelStartY, clickGuiStartX + 108, endY))
	        deltaWheelModule = (deltaWheelModule + wheel * 4f).coerceIn(moduleMaxScroll, 0f)

	    RenderUtils.renderScissorBox(clickGuiStartX, modulePanelStartY, clickGuiStartX + 108, endY - 6) {
	        for ((index, module) in filteredModules.withIndex()) {
	        	val moduleStartX = clickGuiStartX + 10
	            val moduleStartY = modulePanelStartY + 5 + deltaWheelModule + moduleItemHeight * index
	            val colorState = if (module.state) Color(252, 186, 3) else Color(200, 200, 200)
	            fontConsolas.drawString(module.displayName, moduleStartX, moduleStartY, colorState.rgb)
	        }
	    }

		RenderUtils.drawRect(clickGuiStartX + 108, clickGuiStartY + titleHeight, clickGuiStartX + 110, endY, 0f, Color(20, 20, 20))
	
		// value render
		val module = this.currentModule ?: return
		Fonts.fontESP[64].drawString(module.displayName, clickGuiStartX + 115, categoryPanelPosEndY + 16, Color(200, 200, 200).rgb)
		val valueStartY = categoryPanelPosEndY + Fonts.fontESP[64].height + 23

		isHoverOnSlide = false

		RenderUtils.renderScissorBox(clickGuiStartX + 112, valueStartY, endX, endY - 6) {
			var totalValueElementsY = 0f
			val filteredComponents = module.augustusComponents.filter { it.value.canDisplay() }

			for (component in filteredComponents) {
				val valueY = valueStartY + deltaWheelValue + 4 + totalValueElementsY
				component.drawValueName(clickGuiStartX + 115, valueY)
				totalValueElementsY += component.drawValue(mouseX, mouseY, clickGuiStartX + 115, valueY, endX, endY - 6)
			}

			if (!isHoverOnSlide) {
				val valueMaxScroll = -(totalValueElementsY - endY + valueStartY + 6).coerceAtLeast(0f)

			    if (MathUtils.isHover(mouseX, mouseY, clickGuiStartX + 115, valueStartY, endX, endY))
			        deltaWheelValue = (deltaWheelValue + wheel * 4f).coerceIn(valueMaxScroll, 0f)
			}
		}
	}

	override fun mouseClickMove(mouseX: Int, mouseY: Int, clickedMouseButton: Int, timeSinceLastClick: Long) {
		val endX = clickGuiStartX + clickGuiWidth
		val endY = clickGuiStartY + clickGuiHeight

		val titleHeight = Fonts.fontESP[64].height + 10

		// category click handle
		val categoryPanelPosY = clickGuiStartY + titleHeight + 10
		val categoryPanelPosEndY = categoryPanelPosY + fontConsolas.height + 1

		val module = this.currentModule ?: return
		val valueStartY = categoryPanelPosEndY + Fonts.fontESP[64].height + 23
		val filteredComponents = module.augustusComponents.filter { it.value.canDisplay() }
		var totalValueElementsY = 0f

		for (component in filteredComponents) {
			val valueY = valueStartY + deltaWheelValue + 4 + totalValueElementsY
			val incHeight = component.mouseClickMove(mouseX, mouseY, clickGuiStartX + 115, valueY, endX, endY - 6, clickedMouseButton, timeSinceLastClick)

			if (incHeight == 0f)
				return

			totalValueElementsY += incHeight
		}
	}

	override fun mouseClicked(mouseX: Int, mouseY: Int, mouseButton: Int) {
		val endX = clickGuiStartX + clickGuiWidth
		val endY = clickGuiStartY + clickGuiHeight

		val titleHeight = Fonts.fontESP[64].height + 10

		// category click handle
		val categoryPanelPosY = clickGuiStartY + titleHeight + 10
		val categoryPanelPosX = clickGuiStartX + 130
		val categoryPanelPosEndY = categoryPanelPosY + fontConsolas.height + 1
		var categoryPos = 0f

		for (category in ModuleCategory.entries) {
			val stringWidth = fontConsolas.getStringWidth(category.toString())
			val categoryStartX = categoryPanelPosX + categoryPos - 4
			val categoryEndX = categoryStartX + fontConsolas.getStringWidth(category.toString())
			val categoryEndY = categoryPanelPosY + fontConsolas.height + 4

			if (MathUtils.isHover(mouseX, mouseY, categoryStartX, categoryPanelPosY - 4, categoryEndX, categoryEndY) && mouseButton == 0) {
				currentCategory = category
				currentModule = null
				deltaWheelValue = 0f
				deltaWheelModule = 0f
				return
			}

			categoryPos += stringWidth + 15f
		}

		// module click handle
		val filteredModules = BloomClient.moduleManager.modules.filter { it.category == currentCategory }
		
		val modulePanelHeight = clickGuiStartY + titleHeight
		val moduleItemHeight = fontConsolas.height + 6

		for ((index, module) in filteredModules.withIndex()) {
            val moduleStartX = clickGuiStartX + 10
            val moduleStartY = modulePanelHeight + 5 + deltaWheelModule + moduleItemHeight * index - 2f
            val moduleEndX = moduleStartX + fontConsolas.getStringWidth(module.displayName)
            val moduleEndY = moduleStartY + fontConsolas.height - 2f

            if (MathUtils.isHover(mouseX, mouseY, moduleStartX, moduleStartY, moduleEndX, moduleEndY)) {
            	if (mouseButton == 0)
      				module.toggle()
      			else if (mouseButton == 1)
      				currentModule = module

      			return
            }
        }

        val module = this.currentModule ?: return
		val valueStartY = categoryPanelPosEndY + Fonts.fontESP[64].height + 23
		val filteredComponents = module.augustusComponents.filter { it.value.canDisplay() }
		var totalValueElementsY = 0f

		for (component in filteredComponents) {
			val valueY = valueStartY + deltaWheelValue + 4 + totalValueElementsY
			val incHeight = component.mouseClicked(mouseX, mouseY, clickGuiStartX + 115, valueY, endX, endY - 6, mouseButton)

			if (incHeight == 0f)
				return

			totalValueElementsY += incHeight
		}

	}

	override fun mouseReleased(mouseX: Int, mouseY: Int, state: Int) {
		currentModule?.augustusComponents?.forEach { it.mouseReleased(mouseX, mouseY, state) }
	}

	override fun onGuiClosed() {
		FileManager.saveConfig(FileManager.moduleConfig)
	}

	override fun doesGuiPauseGame() = false

	fun getAugustusComponent(value: Value<*>) = when (value) {
		is IntegerValue -> AugustusIntegerValueComponent(value)
		is FloatValue -> AugustusFloatValueComponent(value)
		is BoolValue -> AugustusBoolValueComponent(value)
		is ListValue -> AugustusListValueComponent(value)
		is ModeValue -> AugustusModeValueComponent(value)
		is IntRangeValue -> AugustusIntRangeValueComponent(value)
		is FloatRangeValue -> AugustusFloatRangeValueComponent(value)
		is GroupValue -> AugustusGroupValueComponent(value)
		is EnumValue -> AugustusEnumValueComponent(value)
		else -> null
	}
}