package net.bloom.bloomclient.ui.altmanager.menus

import net.bloom.bloomauthlib.account.SessionAccount
import net.bloom.bloomclient.file.FileManager
import net.bloom.bloomclient.ui.altmanager.GuiAltManager
import net.bloom.bloomclient.utils.TabUtils
import net.minecraft.client.gui.GuiButton
import net.minecraft.client.gui.GuiScreen
import net.minecraft.client.gui.GuiTextField
import org.lwjgl.input.Keyboard
import kotlin.concurrent.thread

class GuiLoginIntoSession(
    private val prevGui: GuiAltManager
) : GuiScreen() {

    private lateinit var loginButton: GuiButton
    private lateinit var tokenField: GuiTextField
    private var status = "§7Idle..."

    override fun initGui() {
        Keyboard.enableRepeatEvents(true)
        buttonList.add(GuiButton(1, width / 2 - 100, height - 54, 98, 20, "Login").also { loginButton = it })
        buttonList.add(GuiButton(0, width / 2 + 2, height - 54, 98, 20, "Back"))
        tokenField = GuiTextField(2, prevGui.font, width / 2 - 100, 80, 200, 20)
        tokenField.isFocused = true
        tokenField.maxStringLength = Int.MAX_VALUE
    }

    override fun drawScreen(mouseX: Int, mouseY: Int, partialTicks: Float) {
        drawBackground(0)
        prevGui.font.drawCenteredString("Direct Login", width / 2.0f, 34f, 0xffffff)
        prevGui.font.drawCenteredString("§7Login with Access Token", width / 2.0f, 49f, 0xffffff)
        prevGui.font.drawCenteredString(status, width / 2.0f, height - 64f, 0xffffff)
        tokenField.drawTextBox()
        if (tokenField.text.isEmpty() && !tokenField.isFocused) {
            prevGui.font.drawCenteredString("§7Access Token", (width / 2 - 55).toFloat(), 86f, 0xffffff)
        }
        super.drawScreen(mouseX, mouseY, partialTicks)
    }

    override fun actionPerformed(button: GuiButton) {
        if (!button.enabled) return
        when (button.id) {
            0 -> mc.displayGuiScreen(prevGui)
            1 -> {
                val token = tokenField.text
                if (token.isBlank()) {
                    status = "§cAccess token cannot be empty."
                    return
                }
                loginButton.enabled = false
                thread(name = "Token-Login-Task") {
                    try {
                        val sessionAccount = SessionAccount().also {
                            it.sessionData = token
                            it.tokenType = SessionAccount.Type.DIRECT
                        }

                        mc.session = sessionAccount.login()
                        FileManager.accountsConfig.addAccount(sessionAccount)
                        status = "§aLogged into ${sessionAccount.username}."
                        prevGui.status = status
                        mc.displayGuiScreen(prevGui)
                    } catch (e: Exception) {
                        status = "§c${e.message ?: "Unknown error"}"
                        loginButton.enabled = true
                    }
                }
            }
        }
    }

    override fun keyTyped(typedChar: Char, keyCode: Int) {
        when (keyCode) {
            Keyboard.KEY_ESCAPE -> mc.displayGuiScreen(prevGui)
            Keyboard.KEY_TAB -> TabUtils.tab(tokenField, tokenField)
            Keyboard.KEY_RETURN -> actionPerformed(loginButton)
        }
        if (tokenField.isFocused) {
            tokenField.textboxKeyTyped(typedChar, keyCode)
        }
        super.keyTyped(typedChar, keyCode)
    }

    override fun mouseClicked(mouseX: Int, mouseY: Int, mouseButton: Int) {
        tokenField.mouseClicked(mouseX, mouseY, mouseButton)
        super.mouseClicked(mouseX, mouseY, mouseButton)
    }

    override fun updateScreen() {
        tokenField.updateCursorCounter()
        super.updateScreen()
    }

    override fun onGuiClosed() {
        Keyboard.enableRepeatEvents(false)
    }
}
