package net.bloom.bloomclient.ui.altmanager

import com.thealtening.AltService
import net.bloom.bloomauthlib.account.CrackedAccount
import net.bloom.bloomauthlib.account.MicrosoftAccount
import net.bloom.bloomauthlib.account.MinecraftAccount
import net.bloom.bloomauthlib.account.SessionAccount
import net.bloom.bloomclient.file.FileManager
import net.bloom.bloomclient.ui.altmanager.menus.GuiChangeName
import net.bloom.bloomclient.ui.altmanager.menus.GuiLoginIntoAccount
import net.bloom.bloomclient.ui.altmanager.menus.GuiLoginIntoSession
import net.bloom.bloomclient.utils.ClientUtils
import net.bloom.bloomclient.utils.DictUtils
import net.bloom.bloomclient.utils.RandomUtils
import net.minecraft.client.Minecraft
import net.minecraft.client.gui.GuiButton
import net.minecraft.client.gui.GuiScreen
import net.minecraft.client.gui.GuiSlot
import net.minecraft.client.gui.GuiTextField
import net.bloom.bloomauthlib.compat.Session
import org.lwjgl.input.Keyboard
import java.awt.Color
import java.awt.Toolkit
import java.awt.datatransfer.StringSelection
import java.util.*
import kotlin.concurrent.thread


enum class BUTTON {
    ADD, REMOVE, IMPORT, EXPORT, COPY, REVERT, BACK, LOGIN, RANDOM, GENERATECRACKED, SEMIRANDOMFMT, CRACKED, DIRECTLOGIN, SESSIONLOGIN, CHANGENAME,
}

class GuiAltManager(private val parent: GuiScreen) : GuiScreen() {
    var status = "§7Idle..."

    private lateinit var loginButton: GuiButton
    private lateinit var randomButton: GuiButton
    private lateinit var generatedCrackedButton: GuiButton
    private lateinit var altsList: GuiList
    private lateinit var searchField: GuiTextField
    private lateinit var revertOriginalAccount: GuiButton

    val font
        get() = this.minecraftFontRendererObj

    var lastSessionToken: String? = null

    override fun initGui() {
        val textFieldWidth = (width / 8).coerceAtLeast(70)
        searchField = GuiTextField(2, font, width - textFieldWidth - 10, 10, textFieldWidth, 20)
        searchField.maxStringLength = Int.MAX_VALUE

        altsList = GuiList(this)
        altsList.registerScrollButtons(7, 8)

        val mightBeTheCurrentAccount = FileManager.accountsConfig.accounts.indexOfFirst { it.username == mc.session.username }
        altsList.elementClicked(mightBeTheCurrentAccount, false, 0, 0)
        altsList.scrollBy(mightBeTheCurrentAccount * altsList.slotHeight)

        // Setup buttons

        val startPositionY = 22

        buttonList.add(GuiButton(BUTTON.ADD.ordinal, width - 80, startPositionY + 24, 70, 20, "Add"))
        buttonList.add(GuiButton(BUTTON.REMOVE.ordinal, width - 80, startPositionY + 24 * 2, 70, 20, "Remove"))
//        buttonList.add(GuiButton(BUTTON.IMPORT.ordinal, width - 80, startPositionY + 24 * 3, 70, 20, "Import"))
//        buttonList.add(GuiButton(BUTTON.EXPORT.ordinal, width - 80, startPositionY + 24 * 4, 70, 20, "Export"))
        buttonList.add(GuiButton(BUTTON.COPY.ordinal, width - 80, startPositionY + 24 * 3, 70, 20, "Copy"))
        buttonList.add(GuiButton(BUTTON.REVERT.ordinal, width - 80, startPositionY + 24 * 4, 70, 20, "Revert").also { revertOriginalAccount = it })
        buttonList.add(GuiButton(BUTTON.BACK.ordinal, width - 80, height - 65, 70, 20, "Back"))

        buttonList.add(GuiButton(BUTTON.SESSIONLOGIN.ordinal, 5, startPositionY + 24, 90, 20, "Add Session"))
        buttonList.add(GuiButton(BUTTON.LOGIN.ordinal, 5, startPositionY + 24 * 2, 90, 20, "Login").also { loginButton = it })
        buttonList.add(GuiButton(BUTTON.RANDOM.ordinal, 5, startPositionY + 24 * 3, 90, 20, "Random Alt").also { randomButton = it })
        buttonList.add(GuiButton(BUTTON.GENERATECRACKED.ordinal, 5, startPositionY + 24 * 5, 90, 20, "Random cracked").also { generatedCrackedButton = it })
        buttonList.add(GuiButton(BUTTON.DIRECTLOGIN.ordinal, 5, startPositionY + 24 * 6, 90, 20, "Direct Login"))
        buttonList.add(GuiButton(BUTTON.CHANGENAME.ordinal, 5, startPositionY + 24 * 7, 90, 20, "Change Name"))
    }

    override fun drawScreen(mouseX: Int, mouseY: Int, partialTicks: Float) {
        revertOriginalAccount.enabled = (lastSessionToken != null)
        drawBackground(0)
        altsList.drawScreen(mouseX, mouseY, partialTicks)
        font.drawCenteredString("AltManager", width / 2.0f, 6f, 0xffffff)
        font.drawCenteredString(
            if (searchField.text.isEmpty()) "${FileManager.accountsConfig.accounts.size} Alts" else altsList.accounts.size.toString() + " Search Results",
            width / 2.0f,
            18f,
            0xffffff
        )
        font.drawCenteredString(status, width / 2.0f, 32f, 0xffffff)
        font.drawStringWithShadow(
            "§7User: §a${mc.getSession().username}",
            6f,
            6f,
            0xffffff
        )
        font.drawStringWithShadow("§7Type: §a${if (mc.session.token.length >= 32) "Premium" else "Cracked"}", 6f, 15f, 0xffffff)
        searchField.drawTextBox()
        if (searchField.text.isEmpty() && !searchField.isFocused) font.drawStringWithShadow(
            "§7Search...",
            (searchField.xPosition + 4).toFloat(),
            17f,
            0xffffff
        )
        generateCracked.drawTextBox()
        super.drawScreen(mouseX, mouseY, partialTicks)
    }

    public override fun actionPerformed(button: GuiButton) {
        // Not enabled buttons should be ignored
        if (!button.enabled)
            return

        when (button.id) {
            BUTTON.BACK.ordinal -> mc.displayGuiScreen(parent)
            BUTTON.ADD.ordinal -> mc.displayGuiScreen(GuiLoginIntoAccount(this))
            BUTTON.SESSIONLOGIN.ordinal -> mc.displayGuiScreen(GuiLoginIntoSession(this))
            BUTTON.REMOVE.ordinal -> {
                status = if (altsList.selectedSlot != -1 && altsList.selectedSlot < altsList.size) {
                    FileManager.accountsConfig.removeAccount(altsList.accounts[altsList.selectedSlot])
                    FileManager.saveConfig(FileManager.accountsConfig)
                    "§aThe account has been removed."
                } else {
                    "§cSelect an account."
                }
            }

            BUTTON.LOGIN.ordinal -> {
                if (lastSessionToken == null)
                    lastSessionToken = mc.session.token

                status = altsList.selectedAccount?.let {
                    loginButton.enabled = false
                    randomButton.enabled = false
                    generatedCrackedButton.enabled = false

                    login(it, {
                        status = "§aLogged into ${mc.session.username}."
                    }, { exception ->
                        status = "§cLogin failed due to '${exception.message}'."
                    }, {
                        loginButton.enabled = true
                        randomButton.enabled = true
                        generatedCrackedButton.enabled = true
                    })

                    "§aLogging in..."
                } ?: "§cSelect an account."
            }

            BUTTON.RANDOM.ordinal -> {
                if (lastSessionToken == null)
                    lastSessionToken = mc.session.token

                status = altsList.accounts.randomOrNull()?.let {
                    loginButton.enabled = false
                    randomButton.enabled = false
                    generatedCrackedButton.enabled = false

                    login(it, {
                        status = "§aLogged into ${mc.session.username}."
                    }, { exception ->
                        status = "§cLogin failed due to '${exception.message}'."
                    }, {
                        loginButton.enabled = true
                        randomButton.enabled = true
                        generatedCrackedButton.enabled = true
                    })

                    "§aLogging in..."
                } ?: "§cYou do not have any accounts."
            }

            BUTTON.CRACKED.ordinal -> {
                if (lastSessionToken == null)
                    lastSessionToken = mc.session.token

                loginButton.enabled = false
                randomButton.enabled = false
                generatedCrackedButton.enabled = false

                val rand = CrackedAccount()
                rand.username = RandomUtils.randomString(RandomUtils.nextInt(5, 16))

                status = "§aGenerating..."

                login(rand, {
                    status = "§aLogged in as ${mc.session.username}."
                }, { exception ->
                    status = "§cLogin failed due to '${exception.message}'."
                }, {
                    loginButton.enabled = true
                    randomButton.enabled = true
                    generatedCrackedButton.enabled = true
                })
            }

            BUTTON.GENERATECRACKED.ordinal -> {
                if (lastSessionToken == null)
                    lastSessionToken = mc.session.token

                loginButton.enabled = false
                randomButton.enabled = false
                generatedCrackedButton.enabled = false

                val rand = CrackedAccount()
                rand.username = DictUtils.get(generateCracked.text)

                status = "§aGenerating..."

                login(rand, {
                    status = "§aLogged in as ${mc.session.username}."
                }, { exception ->
                    status = "§cLogin failed due to '${exception.message}'."
                }, {
                    loginButton.enabled = true
                    randomButton.enabled = true
                    generatedCrackedButton.enabled = true
                })
            }

            BUTTON.DIRECTLOGIN.ordinal -> { // Direct login button
                mc.displayGuiScreen(GuiLoginIntoAccount(this, directLogin = true))
            }

//            BUTTON.IMPORT.ordinal -> { // Import button
//                val file = MiscUtils.openFileChooser() ?: return
//
//                file.readLines().forEach {
//                    val accountData = it.split(":".toRegex(), limit = 2)
//                    if (accountData.size > 1) {
//                        // Most likely mojang account
//                        fileManager.accountsConfig.addMojangAccount(accountData[0], accountData[1])
//                    } else if (accountData[0].length < 16) {
//                        // Might be cracked account
//                        fileManager.accountsConfig.addCrackedAccount(accountData[0])
//                    } // skip account
//                }
//
//                fileManager.saveConfig(fileManager.accountsConfig)
//                status = "§aThe accounts were imported successfully."
//            }

//            BUTTON.EXPORT.ordinal -> { // Export button
//                if (fileManager.accountsConfig.accounts.isEmpty()) {
//                    status = "§cYou do not have any accounts to export."
//                    return
//                }
//
//                val file = MiscUtils.saveFileChooser()
//                if (file == null || file.isDirectory) {
//                    return
//                }
//
//                try {
//                    if (!file.exists()) {
//                        file.createNewFile()
//                    }
//
//                    val accounts = fileManager.accountsConfig.accounts.joinToString(separator = "\n") { account ->
//                        when (account) {
//                            is MojangAccount -> "${account.email}:${account.password}" // EMAIL:PASSWORD
//                            is MicrosoftAccount -> "${account.name}:${account.session.token}" // NAME:SESSION
//                            else -> account.name
//                        }
//                    }
//                    file.writeText(accounts)
//
//                    status = "§aExported successfully!"
//                } catch (e: Exception) {
//                    status = "§cUnable to export due to error: ${e.message}"
//                }
//            }

            BUTTON.COPY.ordinal -> {
                val currentAccount = altsList.selectedAccount

                if (currentAccount == null) {
                    status = "§cSelect an account."
                    return
                }

                // Format data for other tools
                val formattedData = when (currentAccount) {
                    is MicrosoftAccount -> "${currentAccount.username}:${currentAccount.refreshToken}" // NAME:SESSION
                    else -> currentAccount.username
                }

                // Copy to clipboard
                Toolkit.getDefaultToolkit().systemClipboard.setContents(StringSelection(formattedData), null)
                status = "§aCopied account into your clipboard."
            }

            BUTTON.CHANGENAME.ordinal -> { // Gui Change Name Button
                mc.displayGuiScreen(GuiChangeName(this))
            }


            BUTTON.REVERT.ordinal -> {
                loginButton.enabled = false
                randomButton.enabled = false
                generatedCrackedButton.enabled = false
                status = "§aLogging in..."

                val lastSessionToken = this.lastSessionToken ?: return

                val sessionAccount = SessionAccount()
                sessionAccount.sessionData = lastSessionToken
                login(sessionAccount, {
                    status = "§aLogged into ${mc.session.username}."
                }, { exception ->
                    status = "§cLogin failed due to '${exception.message}'."
                }, {
                    loginButton.enabled = true
                    randomButton.enabled = true
                    generatedCrackedButton.enabled = true
                })

                this.lastSessionToken = null
            }
        }
    }

    public override fun keyTyped(typedChar: Char, keyCode: Int) {
        if (searchField.isFocused) {
            searchField.textboxKeyTyped(typedChar, keyCode)
        }

        if (generateCracked.isFocused)
            generateCracked.textboxKeyTyped(typedChar, keyCode)

        when (keyCode) {
            Keyboard.KEY_ESCAPE -> { // Go back
                mc.displayGuiScreen(this.parent)
                return
            }
            Keyboard.KEY_UP -> { // Go one up in account list
                var i = altsList.selectedSlot - 1
                if (i < 0) i = 0
                altsList.elementClicked(i, false, 0, 0)
            }
            Keyboard.KEY_DOWN -> { // Go one down in account list
                var i = altsList.selectedSlot + 1
                if (i >= altsList.size) i = altsList.size - 1
                altsList.elementClicked(i, false, 0, 0)
            }
            Keyboard.KEY_RETURN -> { // Login into account
                altsList.elementClicked(altsList.selectedSlot, true, 0, 0)
            }
            Keyboard.KEY_NEXT -> { // Scroll account list
                altsList.scrollBy(height - 100)
            }
            Keyboard.KEY_PRIOR -> { // Scroll account list
                altsList.scrollBy(-height + 100)
                return
            }
        }

        super.keyTyped(typedChar, keyCode)
    }

    override fun handleMouseInput() {
        super.handleMouseInput()
        altsList.handleMouseInput()
    }

    public override fun mouseClicked(mouseX: Int, mouseY: Int, mouseButton: Int) {
        searchField.mouseClicked(mouseX, mouseY, mouseButton)
        generateCracked.mouseClicked(mouseX, mouseY, mouseButton)
        super.mouseClicked(mouseX, mouseY, mouseButton)
    }

    override fun updateScreen() {
        searchField.updateCursorCounter()
        generateCracked.updateCursorCounter()
    }


    private inner class GuiList(prevGui: GuiScreen) : GuiSlot(mc, prevGui.width, prevGui.height, 40, prevGui.height - 40, 30) {

        val accounts: List<MinecraftAccount>
            get() {
                var search = searchField.text
                if (search == null || search.isEmpty()) {
                    return FileManager.accountsConfig.accounts
                }
                search = search.lowercase(Locale.getDefault())

                return FileManager.accountsConfig.accounts.filter { it.username.contains(search, ignoreCase = true) }
            }

        var selectedSlot = 0
            get() {
                return if (field > accounts.size) {
                    -1
                } else {
                    field
                }
            }

        val selectedAccount: MinecraftAccount?
            get() = if (selectedSlot >= 0 && selectedSlot < accounts.size) {
                accounts[selectedSlot]
            } else {
                null
            }

        override fun isSelected(id: Int) = selectedSlot == id

        public override fun getSize() = accounts.size

        public override fun elementClicked(clickedElement: Int, doubleClick: Boolean, var3: Int, var4: Int) {
            selectedSlot = clickedElement

            if (doubleClick) {
                status = altsList.selectedAccount?.let {
                    loginButton.enabled = false
                    randomButton.enabled = false
                    generatedCrackedButton.enabled = false

                    login(it, {
                        status = "§aLogged into ${mc.session.username}."
                    }, { exception ->
                        status = "§cLogin failed due to '${exception.message}'."
                    }, {
                        loginButton.enabled = true
                        randomButton.enabled = true
                        generatedCrackedButton.enabled = true
                    })

                    "§aLogging in..."
                } ?: "§cSelect an account."
            }
        }

        override fun drawSlot(id: Int, x: Int, y: Int, var4: Int, var5: Int, var6: Int) {
            val minecraftAccount = accounts[id]
            val accountName = minecraftAccount.username

            font.drawCenteredString(accountName, width / 2f, y + 2f, Color.WHITE.rgb, true)
            font.drawCenteredString(
                if (minecraftAccount is CrackedAccount) "Cracked" else if (minecraftAccount is MicrosoftAccount) "Microsoft" else "Something else",
                width / 2f,
                y + 15f,
                if (minecraftAccount is CrackedAccount) Color.GRAY.rgb else Color(118, 255, 95).rgb,
                true
            )
        }

        override fun drawBackground() {}
    }


    companion object {

        val altService = AltService()
        private val activeGenerators = mutableMapOf<String, Boolean>()
        var generateCracked: GuiTextField =
            GuiTextField(BUTTON.SEMIRANDOMFMT.ordinal, Minecraft.getMinecraft().minecraftFontRendererObj, 5, 22 + 24 * 4 + 1, 90, 18)

        init {
            generateCracked.text = "%W%W%d%d%d%d"
            generateCracked.maxStringLength = 100
        }

        fun login(minecraftAccount: MinecraftAccount, success: () -> Unit, error: (Exception) -> Unit, done: () -> Unit) = thread(name = "LoginTask") {
            if (altService.currentService != AltService.EnumAltService.MOJANG) {
                try {
                    altService.switchService(AltService.EnumAltService.MOJANG)
                } catch (e: NoSuchFieldException) {
                    error(e)
                    ClientUtils.LOGGER.error("Something went wrong while trying to switch alt service.", e)
                } catch (e: IllegalAccessException) {
                    error(e)
                    ClientUtils.LOGGER.error("Something went wrong while trying to switch alt service.", e)
                }
            }

            try {
                Minecraft.getMinecraft().session = minecraftAccount.login()
                success()
            } catch (exception: Exception) {
                error(exception)
            }
            done()
        }
    }
}