package net.bloom.bloomclient.font.sizeable

import net.bloom.bloomclient.font.renderer.NanoVGFontRenderer
import net.bloom.bloomclient.font.renderer.legacy.LegacyFontRenderer
import net.minecraft.client.gui.FontSizeable
import java.awt.Font

class NanoVGFontSizeable(name: String, val path: String): FontSizeable(name) {
    private val sizesMap = hashMapOf<Int, NanoVGFontRenderer>()
    private val defaultFont = NanoVGFontRenderer(name, 24, path).also {
        sizesMap[24] = it
    }

    operator fun get(size: Int) = sizesMap[size] ?: defaultFont

    override fun addSize(size: Int) {
        sizesMap[size] = NanoVGFontRenderer(name, size, path, false)
    }

    override fun addSizes(vararg sizes: Int) {
        for (size in sizes) addSize(size)
    }

}