package net.bloom.bloomclient.file.configs

import com.google.gson.JsonObject
import net.bloom.bloomclient.file.FileConfig
import net.minecraft.client.gui.options.page.ShaderPage
import net.minecraft.client.option.options.ShadersOption
import net.optifine.shaders.ShaderManager
import net.optifine.shaders.Shaders
import java.io.File

class ShaderConfig(file: File): FileConfig(file) {
    override fun fromJson(json: JsonObject) {
        for ((key, value) in json.entrySet()) {
            if (key.equals("currentShader", true)) {
                ShaderManager.shaderPacks.find { it.name.equals(value.asString, true) }?.let {
                    ShaderManager.shaderPack = it
                    ShaderPage.temporaryShaderPack = it
                    Shaders.loadShaderPack()
                }
            } else {
                ShadersOption.values.find { it.name.equals(key, true) }?.fromJson(value) ?: println("Not found value: $key")
            }
        }
    }

    override fun toJson(): JsonObject {
        val json = JsonObject()

        for (value in ShadersOption.values)
            json.add(value.name, value.toJson())

        json.addProperty("currentShader", ShaderManager.shaderPack.name)
        return json
    }
}