package net.bloom.bloomclient.file.configs

import com.google.gson.JsonArray
import com.google.gson.JsonObject
import com.google.gson.JsonPrimitive
import net.bloom.bloomclient.file.FileConfig
import net.bloom.bloomclient.utils.extension.toBase64String
import java.io.File

class ResourceConfig(file: File): FileConfig(file) {
    override fun fromJson(json: JsonObject) {
        for ((key, value) in json.entrySet()) {
            when (key.lowercase()) {
                "currentresourcepacks" -> if (value is JsonArray) {
                    val resourcePacks = value.mapNotNull {
                        val encodedString = it.asString.toBase64String()
                        mc.resourcePackRepository.availableResourcePacks.find { foundEntry -> foundEntry.encodedString == encodedString }
                    }.toSet()
                    mc.resourcePackRepository.selectedResourcePacks.addAll(resourcePacks)
                    mc.resourcePackRepository.availableResourcePacks.removeAll(resourcePacks)
                    mc.resourcePackRepository.setRepositories(mc.resourcePackRepository.selectedResourcePacks.map { it.entry }.reversed())
                }
            }
        }
    }

    override fun toJson(): JsonObject {
        val json = JsonObject()

        val array = JsonArray()

        for (resourcePack in mc.resourcePackRepository.selectedResourcePacks)
            array.add(JsonPrimitive(resourcePack.name))

        json.add("currentResourcePacks", array)
        return json
    }
}