package net.bloom.bloomclient.file.configs

import com.google.gson.JsonObject
import com.google.gson.JsonPrimitive
import net.bloom.bloomclient.BloomClient
import net.bloom.bloomclient.file.FileConfig
import java.io.File

class ModuleConfig(file: File): FileConfig(file) {

	override fun fromJson(json: JsonObject) {
		for ((moduleName, attributes) in json.entrySet()) {
			val module = BloomClient.moduleManager.getModule(moduleName) ?: continue

			if (!attributes.isJsonObject)
				continue

			for ((key, value) in attributes.asJsonObject.entrySet()) when (key.lowercase()) {
				"keybind" -> module.keyBind = value.asInt
				"state" -> module.state = value.asBoolean
				else -> {
					if (!value.isJsonObject)
						continue

					val valueAttrs = value.asJsonObject

					for (valueItem in module.values) {
						val moduleValue = valueAttrs[valueItem.name] ?: continue
						valueItem.fromJson(moduleValue)
					}
				}
			}
		}
	}

	override fun toJson(): JsonObject {
		val json = JsonObject()

		BloomClient.moduleManager.modules.filter { it.values.isNotEmpty() }.forEach { module ->
			val moduleJson = JsonObject()
			moduleJson.add("keybind", JsonPrimitive(module.keyBind))
			moduleJson.add("state", JsonPrimitive(module.state))

			val valuesObject = JsonObject()
			module.values.forEach { valuesObject.add(it.name, it.toJson()) }

			moduleJson.add("values", valuesObject)
			json.add(module.name, moduleJson)
		}

		return json
	}
}