package net.bloom.bloomclient.file.configs

import com.google.gson.JsonObject
import net.bloom.bloomclient.file.FileConfig
import net.minecraft.client.option.OptionManager
import net.optifine.shaders.ShaderManager
import java.io.File

class MinecraftConfig(file: File): FileConfig(file) {
    override fun fromJson(json: JsonObject) {
        for ((keyCategory, valueCategory) in json.entrySet()) {
            if (valueCategory !is JsonObject)
                continue

            val category = OptionManager.configCategories.find { it.name.equals(keyCategory, true) } ?: continue
            val values = category.values
            for ((key, value) in valueCategory.entrySet())
                values.find { it.name.equals(key, true) }?.fromJson(value) ?: println("Not found value: $key")
        }

        OptionManager.applyValue()
    }

    override fun toJson(): JsonObject {
        val json = JsonObject()

        for (category in OptionManager.configCategories) {
            val categoryJson = JsonObject()

            for (value in category.values)
                categoryJson.add(value.name, value.toJson())

            json.add(category.name, categoryJson)
        }

        json.addProperty("currentShader", ShaderManager.shaderPack.name)
        return json
    }


}