package net.bloom.bloomclient.file.configs

import com.google.gson.JsonObject
import com.google.gson.JsonPrimitive
import net.bloom.bloomclient.BloomClient
import net.bloom.bloomclient.file.FileConfig
import java.io.File

class GeneralConfig(file: File): FileConfig(file) {
	override fun fromJson(json: JsonObject) {
		for ((key, value) in json.entrySet()) when (key.lowercase()) {
			"prefix" -> BloomClient.commandManager.prefix = value.asString
		}
	}

	override fun toJson(): JsonObject {
		val json = JsonObject()
		json.add("prefix", JsonPrimitive(BloomClient.commandManager.prefix))

		return json
	}

}