package net.bloom.bloomclient.file.configs

import com.google.gson.*
import net.bloom.bloomauthlib.account.CrackedAccount
import net.bloom.bloomauthlib.account.MinecraftAccount
import net.bloom.bloomauthlib.manage.AccountSerializer
import net.bloom.bloomclient.file.FileConfig
import java.io.*

class AccountsConfig(file: File): FileConfig(file) {

    val accounts = mutableListOf<MinecraftAccount>()

    override fun fromJson(json: JsonObject) {
        accounts.clear()

        val jsonArray = json.asJsonObject.get("accounts")
        if (jsonArray is JsonNull || jsonArray !is JsonArray) return

        for (accountElement in jsonArray.getAsJsonArray()) {
            val accountObject = accountElement.getAsJsonObject()

            try {
                // Import Elixir account format
                accounts.add(AccountSerializer.fromJson(accountElement.getAsJsonObject())!!)
            } catch (e: JsonSyntaxException) {
                // Import old account forma
                val name = accountObject.get("name")
                val crackedAccount = CrackedAccount()
                crackedAccount.username = name.asString
                accounts.add(crackedAccount)

            } catch (e: IllegalStateException) {
                val name = accountObject.get("name")
                val crackedAccount = CrackedAccount()
                crackedAccount.username = name.asString
                accounts.add(crackedAccount)
            }
        }
    }

    fun removeAccount(account: MinecraftAccount?) {
        accounts.remove(account)
    }

    fun addAccount(account: MinecraftAccount?) {
        accounts.add(account!!)
    }

    fun accountExists(newAccount: MinecraftAccount): Boolean {
        for (minecraftAccount in accounts) if (minecraftAccount::class.java.getName().equals(newAccount::class.java.getName()) && minecraftAccount.username == newAccount.username) return true
        return false
    }

    override fun toJson(): JsonObject {
        val jsonArray = JsonArray()
        val jsonObject = JsonObject()

        for (minecraftAccount in accounts) {
            jsonArray.add(minecraftAccount.toJson())
        }

        jsonObject.add("accounts", jsonArray)

        return jsonObject
    }
}