package net.bloom.bloomclient.features.module.modules.world.scaffold.techniques

import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.features.module.modules.world.ModuleScaffold
import net.bloom.bloomclient.utils.Constants
import net.bloom.bloomclient.utils.extension.component1
import net.bloom.bloomclient.utils.extension.component2
import net.bloom.bloomclient.utils.extension.component3
import net.bloom.bloomclient.utils.extension.plus
import net.bloom.bloomclient.utils.player.MovementUtils
import net.bloom.bloomclient.utils.player.MovementUtils.isMoving
import net.bloom.bloomclient.utils.simulation.SimulatedPlayer
import net.minecraft.init.Blocks
import net.minecraft.util.*
import kotlin.math.cos
import kotlin.math.round
import kotlin.math.sin

open class TechniqueMode(name: String) : Mode(name) {
    open fun calculateRotation(movingObjectPos: MovingObjectPosition, blockPos: BlockPos, enumFacing: EnumFacing) {}
}

object NormalTechnique : TechniqueMode("Normal") {
    override fun calculateRotation(movingObjectPos: MovingObjectPosition, blockPos: BlockPos, enumFacing: EnumFacing) {
        if(movingObjectPos.blockPos != blockPos || movingObjectPos.sideHit != enumFacing) {
            ModuleScaffold.rotationSearch.calculateRotation(blockPos, enumFacing)
        }
    }
}

object ExpandTechnique : TechniqueMode("Expand") {
    private val expandLength by int("ExpandLength", 5, 0, 10)

    override fun calculateRotation(movingObjectPos: MovingObjectPosition, blockPos: BlockPos, enumFacing: EnumFacing) {
        ModuleScaffold.rotationSearch.calculateRotation(blockPos, enumFacing)
    }

    fun calculateFacing(pos: BlockPos): Pair<BlockPos, EnumFacing>? {
        for ((offset, facing) in Constants.BLOCKFACINGS) {
            val checkPos = pos.add(offset)
            if (mc.theWorld.getBlockState(checkPos).block != Blocks.air)
                return checkPos to facing
        }

        return null
    }

    fun findBlockOnExpand(position: Vec3): BlockPos {
        var blockPos = position

        if (expandLength > 0) {
            val direction = MovementUtils.getDirectionToRadians(mc.thePlayer.playerYaw)
            val expandVector = Vec3(-sin(direction), position.yCoord, cos(direction))
            var bestExpand = 0

            for (length in 0..expandLength) {
                val blockPlace = BlockPos(position + Vec3(expandVector.xCoord * length, 0.0, expandVector.zCoord * length))
                val (_, enumFacing) = calculateFacing(blockPlace) ?: continue
                if (enumFacing != EnumFacing.UP)
                    bestExpand = length
            }

            blockPos = position + Vec3(expandVector.xCoord * bestExpand, 0.0, expandVector.zCoord * bestExpand)
        }

        return BlockPos(blockPos)
    }


}

object ProtectedSpawnTechnique : TechniqueMode("ProtectedSpawn") {
    override fun calculateRotation(movingObjectPos: MovingObjectPosition, blockPos: BlockPos, enumFacing: EnumFacing) {
        ModuleScaffold.targetRotation = mc.thePlayer.playerRotation
    }
}

object TellyTechnique : TechniqueMode("Telly") {
    private val ticks = int("Ticks", 3, 0, 10)

    override fun calculateRotation(movingObjectPos: MovingObjectPosition, blockPos: BlockPos, enumFacing: EnumFacing) {
        if (mc.thePlayer.offGroundTicks >= ticks.get()) {
            ModuleScaffold.rotationSearch.calculateRotation(blockPos, enumFacing)
        } else if (isMoving) {
            ModuleScaffold.targetRotation = mc.thePlayer.playerRotation
        }
    }
}

object WalkTechnique : TechniqueMode("Walk") {
    override fun calculateRotation(movingObjectPos: MovingObjectPosition, blockPos: BlockPos, enumFacing: EnumFacing) {
        if (movingObjectPos.blockPos != blockPos) {
            ModuleScaffold.rotationSearch.calculateRotation(blockPos, enumFacing)
        }
    }

}

object GodBridgeTechnique : TechniqueMode("GodBridge") {
    override fun calculateRotation(movingObjectPos: MovingObjectPosition, blockPos: BlockPos, enumFacing: EnumFacing) {
        val direction = MovementUtils.getDirection(mc.thePlayer.playerYaw) + 180f
        val movingYaw = round(direction / 45) * 45
        val isMovingForward = movingYaw % 90 == 0f
        val ray = mc.thePlayer.rayTrace(mc.playerController.blockReachDistance.toDouble(), 1.0F)

        if ((ray.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK && ray.blockPos != blockPos) || isMovingForward != ModuleScaffold.lastMovingForward) {
            for (yaw in floatArrayOf(-45f, 45f, -135f, 135f)) {
                val rotation = Rotation(yaw, if (isMovingForward) 73.5f else 75.6f)
                val hitBlock = mc.thePlayer.rayTrace(rotation.yaw, rotation.pitch, mc.playerController.blockReachDistance.toDouble(), 1.0F)
                if (hitBlock.blockPos == blockPos)
                    ModuleScaffold.targetRotation = rotation
            }
        }

        ModuleScaffold.lastMovingForward = isMovingForward
    }
}

object NinjaBridgeTechnique: TechniqueMode("NinjaBridge") {
    override fun calculateRotation(movingObjectPos: MovingObjectPosition, blockPos: BlockPos, enumFacing: EnumFacing) {
        val direction = MovementUtils.getDirection(mc.thePlayer.playerYaw) + 180f
        val movingYaw = round(direction / 45) * 45
        val isMovingForward = movingYaw % 90 == 0f

        if (movingObjectPos.blockPos != blockPos || isMovingForward != ModuleScaffold.lastMovingForward) {
            for (yaw in floatArrayOf(-45f, 45f, -135f, 135f)) {
                val rotation = Rotation(yaw, 78.5f)
                val hitBlock = mc.thePlayer.rayTrace(rotation.yaw, rotation.pitch, mc.playerController.blockReachDistance.toDouble(), 1.0F)
                if (hitBlock.blockPos == blockPos)
                    ModuleScaffold.targetRotation = rotation
            }
        }

        ModuleScaffold.lastMovingForward = isMovingForward
    }
}

object BreezilyTechnique: TechniqueMode("Breezily") {
    override fun calculateRotation(movingObjectPos: MovingObjectPosition, blockPos: BlockPos, enumFacing: EnumFacing) {
        val direction = MovementUtils.getDirection(mc.thePlayer.playerYaw) + 180f
        val movingYaw = round(direction / 90) * 90
        ModuleScaffold.targetRotation = Rotation(movingYaw, 80f)
    }
}