package net.bloom.bloomclient.features.module.modules.world.scaffold.sprint

import net.bloom.bloomclient.event.PostSprintEvent
import net.bloom.bloomclient.event.PreSprintEvent
import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.utils.player.MovementUtils.isMoving
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.util.MathHelper
import kotlin.math.abs

object NormalSprint : Mode("Normal") {
    @EventHandler(priority = -5)
    fun onSprint(event: PreSprintEvent) {
        KeyBinding.keyBindSprint.isKeyDown = true
    }
}

object LegitSprint : Mode("Legit") {
    @EventHandler(priority = -5)
    fun onSprint(event: PreSprintEvent) {
        val playerYaw = MathHelper.wrapAngleTo180(mc.thePlayer.playerYaw)
        val currentYaw = MathHelper.wrapAngleTo180(mc.thePlayer.rotationYaw)

        KeyBinding.keyBindSprint.isKeyDown = abs(playerYaw - currentYaw) <= 90
    }
}

object OffSprint : Mode("Off") {
    @EventHandler(priority = -5)
    fun onSprint(event: PreSprintEvent) {
        KeyBinding.keyBindSprint.isKeyDown = false
        mc.thePlayer.isSprinting = false
    }
}

object OmniSprint : Mode("Omni") {
    @EventHandler
    fun onPostSprint(event: PostSprintEvent) {
        mc.thePlayer.isSprinting = isMoving
    }
}

object ToggleSprint : Mode("Toggle") {
    @EventHandler
    fun onPostSprint(event: PostSprintEvent) {
        if (isMoving) {
            mc.thePlayer.sendStopSprintingPacket()
            mc.thePlayer.sendStartSprintingPacket()
            mc.thePlayer.isSprinting = true
        }
    }
}