package net.bloom.bloomclient.features.module.modules.world.scaffold.sneaking

import net.bloom.bloomclient.event.MoveInputEvent
import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.features.module.modules.world.ModuleScaffold.placedBlocksWithoutEagle
import net.bloom.bloomclient.utils.RandomUtils
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.block.BlockAir
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.network.play.client.C0BPacketEntityAction
import net.minecraft.util.BlockPos
import net.minecraft.util.EnumFacing
import kotlin.math.abs

open class SneakingMode(name: String) : Mode(name) {
    protected fun calculateBlockDifference(min: Float, max: Float): Triple<BlockPos, Double, Float> {
        var dif = 0.5
        val edge = RandomUtils.nextFloat(min, max)
        val blockPos = BlockPos(mc.thePlayer).offset(EnumFacing.DOWN)

        if (edge > 0f) {
            for (facingType in EnumFacing.entries) {
                if (facingType.axis == EnumFacing.Axis.Y) // up and down <=> axis Y
                    continue

                val neighbor = blockPos.offset(facingType)
                if (blockPos.block is BlockAir) {
                    var calcDif = if (facingType.axis == EnumFacing.Axis.Z) // north and south <=> axis Z
                        abs(neighbor.z + 0.5 - mc.thePlayer.posZ)
                    else
                        abs(neighbor.x + 0.5 - mc.thePlayer.posX)

                    calcDif -= 0.5

                    if (calcDif < dif)
                        dif = calcDif
                }
            }
        }

        return Triple(blockPos, dif, edge)
    }
}

object NormalSneaking : SneakingMode("Normal") {
    private val edgeDistance by floatRange("EdgeDistance", 0f, 0.0f, 0.0f, 0.2f)
    private val eagleBlocks by int("EagleBlocks", 0, 0, 10)

    @EventHandler
    fun onMove(event: MoveInputEvent) {
        val (blockPos, dif, edge) = calculateBlockDifference(edgeDistance.minimum, edgeDistance.maximum)

        if (placedBlocksWithoutEagle == 0 && mc.thePlayer.onGround) {
            event.sneak = blockPos.block is BlockAir || dif < edge
        } else if (placedBlocksWithoutEagle >= eagleBlocks)
            placedBlocksWithoutEagle = 0
    }
}

object SilentSneaking : SneakingMode("Silent") {
    private val edgeDistance by floatRange("EdgeDistance", 0f, 0.0f, 0.0f, 0.2f)
    private val eagleBlocks by int("EagleBlocks", 0, 0, 10)
    private var eagleSneaking = false

    @EventHandler
    fun onMove(event: MoveInputEvent) {
        val (blockPos, dif, edge) = calculateBlockDifference(edgeDistance.minimum, edgeDistance.maximum)

        if (placedBlocksWithoutEagle == 0 && mc.thePlayer.onGround) {
            val shouldEagle = blockPos.block is BlockAir || (edge > 0 && dif < edge)

            if (eagleSneaking != shouldEagle)
                mc.netHandler.addToSendQueue(
                    C0BPacketEntityAction(
                        mc.thePlayer,
                        if (shouldEagle) C0BPacketEntityAction.Action.START_SNEAKING else C0BPacketEntityAction.Action.STOP_SNEAKING
                    )
                )

            eagleSneaking = shouldEagle
        } else if (placedBlocksWithoutEagle >= eagleBlocks)
            placedBlocksWithoutEagle = 0
    }
}

object NoSneaking : SneakingMode("None")