package net.bloom.bloomclient.features.module.modules.world.scaffold.rotationsearch

import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.features.module.modules.world.ModuleScaffold
import net.bloom.bloomclient.utils.extension.iterator
import net.bloom.bloomclient.utils.extension.plus
import net.bloom.bloomclient.utils.extension.step
import net.bloom.bloomclient.utils.player.MovementUtils
import net.bloom.bloomclient.utils.player.RotationUtils
import net.bloom.bloomclient.utils.player.RotationUtils.toRotation
import net.minecraft.util.BlockPos
import net.minecraft.util.EnumFacing
import net.minecraft.util.Rotation
import net.minecraft.util.Vec3


abstract class RotationSearchMode(name: String): Mode(name) {
    abstract fun calculateRotation(blockPos: BlockPos, enumFacing: EnumFacing)
}

object HalfEyesSearchMode: RotationSearchMode("HalfEyes") {
    override fun calculateRotation(blockPos: BlockPos, enumFacing: EnumFacing) {
        val dirVec = Vec3(enumFacing.directionVec)
        val posVec = Vec3(blockPos) + Vec3(0.5, 0.5, 0.5)
        val vec = posVec + Vec3(dirVec.xCoord * 0.5, dirVec.yCoord * 0.5, dirVec.zCoord * 0.5)

        val rotation = toRotation(vec)
        val hitBlock = mc.thePlayer.rayTrace(rotation.yaw, rotation.pitch, mc.playerController.blockReachDistance.toDouble(), 1.0F)
        if (hitBlock.blockPos == blockPos && hitBlock.sideHit == enumFacing) {
            ModuleScaffold.targetRotation = rotation
        }
    }
}

object TryRotationSearchMode: RotationSearchMode("TryRotation") {
    private val sensitivity by float("Sensitivity", 0.5f, 0.01f, 1f)

    private val yawMode by list("YawMode", "Custom", arrayOf("Custom", "ReverseYaw", "45", "ForwardYaw"))
    private val yawStepBy by list("YawStepBy", "Custom", arrayOf("Custom", "DeltaSensitivity"))
    private val customYawStep by float("YawStep", 45f, 1f, 90f) { yawMode == "Custom" }
    private val pitchRange by floatRange("PitchRange", 30f, 90f, -90f, 90f)
    private val pitchStepBy by list("PitchStepBy", "Custom", arrayOf("Custom", "DeltaSensitivity"))
    private val customPitchStep by float("PitchStep", 0.1f, 0.01f, 10f)
    private val selectRotationBy by list("SelectRotationBy", "FirstFound", arrayOf("FirstFound", "Nearest"))

    override fun calculateRotation(blockPos: BlockPos, enumFacing: EnumFacing) {
        val yawStep = if (yawStepBy == "Custom") customYawStep else RotationUtils.getDeltaSensitivity(sensitivity)
        val yawList = when (yawMode.lowercase()) {
            "reverseyaw" -> listOf(MovementUtils.getDirection(mc.thePlayer.playerYaw) + 180f)
            "45" -> listOf(-135f, -45f, 45f, 135f)
            "forwardyaw" -> listOf(MovementUtils.getDirection(mc.thePlayer.playerYaw))
            else -> (-180f..180f step yawStep).toList()
        }

        val pitchStep = if (pitchStepBy == "Custom") customPitchStep else RotationUtils.getDeltaSensitivity(sensitivity)
        val pitchRange = this.pitchRange.getValueRangeFloat(pitchStep).toList()
        val possibleRotations = mutableListOf<Rotation>()

        for (yaw in yawList) {
            for (pitch in pitchRange) {
                val rotation = Rotation(yaw, pitch)
                val hitBlock = mc.thePlayer.rayTrace(rotation.yaw, rotation.pitch, mc.playerController.blockReachDistance.toDouble(), 1.0F)
                if (hitBlock.blockPos == blockPos && hitBlock.sideHit == enumFacing) {
                    if (selectRotationBy == "FirstFound") {
                        ModuleScaffold.targetRotation = rotation
                        return
                    } else possibleRotations.add(rotation)
                }
            }
        }

        // Not need to find nearest rotation if this client can't find a possible rotation.
        if (possibleRotations.isEmpty())
            return

        // Rotation which is the nearest with thePlayer's rotation
        ModuleScaffold.targetRotation = possibleRotations.minBy {
            RotationUtils.getRotationDifference(it, mc.thePlayer.rotation)
        }
    }
}

object AreaSearchMode: RotationSearchMode("Area") {
    override fun calculateRotation(blockPos: BlockPos, enumFacing: EnumFacing) {
        var bestRotation: Rotation? = null

        for (x in 0.1..0.9) {
            for (y in 0.1..0.9) {
                for (z in 0.1..0.9) {
                    val dirVec = Vec3(enumFacing.directionVec)
                    val posVec = Vec3(blockPos) + Vec3(x, y, z)
                    val vec = posVec + Vec3(dirVec.xCoord * x, dirVec.yCoord * y, dirVec.zCoord * z)

                    val rotation = toRotation(vec)
                    val hitBlock = mc.thePlayer.rayTrace(rotation.yaw, rotation.pitch, mc.playerController.blockReachDistance.toDouble(), 1.0F) ?: continue
                    if (hitBlock.blockPos == blockPos && hitBlock.sideHit == enumFacing) {
                        if (bestRotation == null || RotationUtils.getRotationDifference(rotation) < RotationUtils.getRotationDifference(bestRotation))
                            bestRotation = rotation
                    }
                }
            }
        }

        ModuleScaffold.targetRotation = bestRotation ?: return
    }
}