package net.bloom.bloomclient.features.module.modules.world.scaffold.adstrafe

import net.bloom.bloomclient.event.MoveInputEvent
import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.features.module.modules.world.ModuleScaffold
import net.bloom.bloomclient.utils.player.MovementUtils.isMoving
import net.bloom.bloomclient.utils.struct.MSTimer
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.block.BlockAir
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.util.BlockPos
import net.minecraft.util.EnumFacing

object ADStrafeAlways : Mode("Always") {
    private val leftDelayValue by int("LeftDelay", 125, 0, 1000)
    private val rightDelayValue by int("RightDelay", 125, 0, 1000)

    private var adStrafeDirection: Boolean = false
    private val adStrafeTimer = MSTimer()

    @EventHandler
    fun onInput(event: MoveInputEvent) {
        if (adStrafeDirection && adStrafeTimer.hasTimePassed(rightDelayValue)) {
            adStrafeDirection = false
            adStrafeTimer.reset()
        } else if (!adStrafeDirection && adStrafeTimer.hasTimePassed(leftDelayValue)) {
            adStrafeDirection = true
            adStrafeTimer.reset()
        }

        if (isMoving && !KeyBinding.keyBindLeft.isKeyDown && !KeyBinding.keyBindRight.isKeyDown)
            event.strafe = if (adStrafeDirection) 1.0F else -1.0F
    }
}

object ADStrafeOnEdge : Mode("Edge") {

    @EventHandler
    fun onInput(event: MoveInputEvent) {
        val blockPos = BlockPos(mc.thePlayer).down()
        if (blockPos.block is BlockAir && mc.currentScreen == null && !KeyBinding.keyBindJump.isKeyDown && event.forward != 0.0F) {
            val index = (mc.thePlayer.rotationYaw / 90.0 + 0.5).toInt() and 3

            event.strafe = when (EnumFacing.getHorizontal(index)) {
                EnumFacing.EAST -> if (blockPos.z + 0.5 > mc.thePlayer.posZ) 1f else -1f
                EnumFacing.WEST -> if (blockPos.z + 0.5 < mc.thePlayer.posZ) 1f else -1f
                EnumFacing.SOUTH -> if (blockPos.x + 0.5 < mc.thePlayer.posX) 1f else -1f
                else -> if (blockPos.x + 0.5 > mc.thePlayer.posX) 1f else -1f
            }
        }
    }

}

object NoADStrafe : Mode("None")