package net.bloom.bloomclient.features.module.modules.world

import net.bloom.bloomclient.event.*
import net.bloom.bloomclient.features.component.components.player.MovementCorrection
import net.bloom.bloomclient.features.component.components.player.PacketComponent
import net.bloom.bloomclient.features.component.components.player.RotationComponent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.features.module.modules.world.scaffold.adstrafe.ADStrafeAlways
import net.bloom.bloomclient.features.module.modules.world.scaffold.adstrafe.ADStrafeOnEdge
import net.bloom.bloomclient.features.module.modules.world.scaffold.adstrafe.NoADStrafe
import net.bloom.bloomclient.features.module.modules.world.scaffold.rotationsearch.AreaSearchMode
import net.bloom.bloomclient.features.module.modules.world.scaffold.rotationsearch.HalfEyesSearchMode
import net.bloom.bloomclient.features.module.modules.world.scaffold.rotationsearch.TryRotationSearchMode
import net.bloom.bloomclient.features.module.modules.world.scaffold.sneaking.NoSneaking
import net.bloom.bloomclient.features.module.modules.world.scaffold.sneaking.NormalSneaking
import net.bloom.bloomclient.features.module.modules.world.scaffold.sneaking.SilentSneaking
import net.bloom.bloomclient.features.module.modules.world.scaffold.sprint.*
import net.bloom.bloomclient.features.module.modules.world.scaffold.techniques.*
import net.bloom.bloomclient.features.module.modules.world.scaffold.tower.*
import net.bloom.bloomclient.features.shared.rotationspeed.HumanizedRotationSpeedMode
import net.bloom.bloomclient.features.shared.rotationspeed.LinearRotationSpeedMode
import net.bloom.bloomclient.utils.Constants
import net.bloom.bloomclient.utils.RandomUtils
import net.bloom.bloomclient.utils.player.MovementUtils.isMoving
import net.bloom.bloomclient.utils.player.RotationUtils
import net.bloom.bloomclient.utils.simulation.SimulatedPlayer
import net.bloom.bloomclient.utils.struct.MSTimer
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.block.*
import net.minecraft.block.material.Material
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.init.Blocks
import net.minecraft.item.ItemBlock
import net.minecraft.network.play.client.C03PacketPlayer.C06PacketPlayerPosLook
import net.minecraft.util.*
import kotlin.math.cos
import kotlin.math.floor


/**
 * TODO: Merge blockPos, enumFacing, and vec to a data class
 */
object ModuleScaffold: Module("Scaffold", "Scaffold", "Scaffold with techniques", ModuleCategory.WORLD) {
    private val techniqueMode by mode("Mode", arrayOf(
        NormalTechnique,
        ExpandTechnique,
        ProtectedSpawnTechnique,
        TellyTechnique,
        WalkTechnique,
        GodBridgeTechnique,
        NinjaBridgeTechnique,
        BreezilyTechnique
    ))
    val towerModes = mode("Tower", arrayOf(AirTower, MatrixTower, NCPTower, VanillaTower, VulcanTower, MMCTower, WatchDogTower, NormalTower, LowHopTower, FastJumpTower, LegitTower, NoTower))
    private val towerSprint = list("TowerSprint", "Normal", arrayOf("Normal", "MotionY"))
    private val towerSprintFix = bool("TowerSprintFix", true) { towerSprint.equals("motiony") }
    val sprintModes = mode("Sprint", arrayOf(NormalSprint, LegitSprint, OmniSprint, ToggleSprint, OffSprint))
    val sneaking = mode("Sneaking", arrayOf(SilentSneaking, NormalSneaking, NoSneaking))
    val adStrafe = mode("ADStrafe", arrayOf(ADStrafeAlways, ADStrafeOnEdge, NoADStrafe))
    private val waitForRotation by bool("WaitForRotation", false)
    private val grimexploit by bool("OldGrim117Exploit", false)
    private val startSneakDelay by int("StartSneakDelay", 250, 0, 1000) { waitForRotation }

    // Block slot selection
    private val switchOnOtherSlotIf by list("SwitchOnOtherSlotIf", "None", arrayOf("StackSizeIsInReached", "OtherSlotStackIsLargerThanIt", "None"))
    private val stackSizeToSwitchOnOtherSlot by int("StackSizeToSwitchOnOtherSlot", 0, 0, 64) { switchOnOtherSlotIf == "StackSizeIsInReached" }

    //Rotation
    val rotationSearch by mode("RotationSearch", arrayOf(TryRotationSearchMode, AreaSearchMode, HalfEyesSearchMode))
    private val rotationYawSpeed by floatRange("YawSpeed", 60F, 60f, 0F, 180f)
    private val rotationPitchSpeed by floatRange("PitchSpeed", 60F, 60f, 0F, 180f)
    private val rotationSpeedMode by mode("RotationSpeedMode", arrayOf(LinearRotationSpeedMode(), HumanizedRotationSpeedMode()))
    private val resetTicks by int("ResetTicks", 0, 0, 20)

    private val sameY by list("SameY", "Off", arrayOf("Off", "Same", "Jump"))
    private val timer = float("Timer", 1f, 0.1f, 5f)
    private val safeWalk = bool("SafeWalk", false)
    private val movementCorrection by enum("MovementCorrection", MovementCorrection.Type.FULL)

    var startY = 0.0
    var blockPos: BlockPos = BlockPos.ORIGIN
    private var enumFacing: EnumFacing = EnumFacing.UP
    var targetRotation = Rotation(0f, 0f)
    var placedBlocksWithoutEagle = 0

    // Moving forward
    var lastMovingForward = false

    private val startSneakTimer = MSTimer()

    override fun onDisable() {
        KeyBinding.keyBindUseItem.isKeyDown = false
        KeyBinding.keyBindSneak.isKeyDown = KeyBinding.isKeyDown(KeyBinding.keyBindSneak)
        KeyBinding.keyBindSprint.isKeyDown = false
        mc.timer.timerSpeed = 1f
        startSneakTimer.reset()
    }

    override fun onEnable() {
        mc.thePlayer ?: return
        startY = floor(mc.thePlayer.posY)
    }

    @EventHandler
    fun onGameLoop(event: GameLoopEvent) {
        mc.timer.timerSpeed = timer.get()
    }

    @EventHandler
    fun onPost(event: PostMotionEvent){
        if(grimexploit){
            PacketComponent.sendPacket(
                C06PacketPlayerPosLook(mc.thePlayer)
            )
        }
    }

    @EventHandler
    fun onJump(event: JumpEvent){
        if (towerSprint.get().lowercase() == "motiony") {
            event.sprint = false
            event.sprintFixes = towerSprintFix.get()
        }
    }

    // Calculate block pos if same y is enabled.
    private fun calculateSameY() {
        when {
            mc.thePlayer.onGround || (KeyBinding.keyBindJump.isKeyDown && !isMoving) -> startY = floor(mc.thePlayer.posY)
            mc.thePlayer.posY < startY -> startY = mc.thePlayer.posY
        }
    }

    private fun calculateBlockPos() {
        val playerPosition = Vec3(mc.thePlayer)
        val playerPos = BlockPos(mc.thePlayer)

        val blockPoses = mutableListOf<BlockPos>()
        val searchHeights = if (canSameY) listOf((startY - 1).toInt()) else (playerPos.y - 1 downTo playerPos.y - 6).toList()

        for (y in searchHeights) {
            for (x in playerPos.x + 6 downTo playerPos.x - 6) {
                for (z in playerPos.z + 6 downTo playerPos.z - 6) {
                    val blockPos = BlockPos(x, y, z)

                    val block = mc.theWorld.getBlockState(blockPos).block
                    if (block is BlockLiquid || block is BlockAir || block is BlockChest || block is BlockFurnace)
                        continue

                    blockPoses.add(blockPos)
                }
            }
        }

        if (blockPoses.isEmpty()) // Not needed to calculate blockPos if this list is empty
            return

        blockPos = blockPoses.minBy {
            val vec = clampHitVec(playerPosition, it)
            mc.thePlayer.getDistance(vec.xCoord, vec.yCoord, vec.zCoord)
        }
    }

    private fun calculateEnumFacing() {
        val playerPosition = Vec3(mc.thePlayer)
        val facings = mutableListOf<EnumFacing>()

        for (facing in EnumFacing.VALUES) {
            if (facing == EnumFacing.UP && canSameY)
                continue

            val neighborPos = blockPos.add(facing.directionVec)
            if (neighborPos == BlockPos(mc.thePlayer))
                continue

            val neighborBlock = mc.theWorld.getBlockState(neighborPos).block

            if ((neighborBlock.material.isSolid || !neighborBlock.isTranslucent || neighborBlock is BlockLadder || neighborBlock is BlockCarpet || neighborBlock is BlockSnow || neighborBlock is BlockSkull) &&
                !neighborBlock.material.isLiquid && neighborBlock !is BlockContainer)
                continue

            facings.add(facing)
        }

        if (facings.isEmpty()) // Not needed to calculate enumfacing if this list is empty
            return

        enumFacing = facings.minBy {
            val neighborPos = blockPos.add(it.directionVec)
            val vec = clampHitVec(playerPosition, neighborPos)
            mc.thePlayer.getDistance(vec.xCoord, vec.yCoord, vec.zCoord)
        }
    }

    @EventHandler
    fun onGame(event: GameLoopEvent){
        mc.thePlayer ?: return

        calculateSameY()

        if (techniqueMode == ExpandTechnique) {
            val playerY = if (canSameY) startY else mc.thePlayer.posY
            val targetBlock = ExpandTechnique.findBlockOnExpand(Vec3(mc.thePlayer.posX, playerY - 1, mc.thePlayer.posZ))
            val placeInfo = calculateFacing(targetBlock) ?: return
            blockPos = placeInfo.first
            enumFacing = placeInfo.second
        } else {
            calculateBlockPos()
            calculateEnumFacing()
        }
    }

    @EventHandler
    fun onRotation(event: PlayerRotationEvent) {
        mc.thePlayer ?: return
        mc.objectMouseOver ?: return

        mc.entityRenderer.getMouseOver(1.0F)

        techniqueMode.calculateRotation(mc.objectMouseOver, blockPos, enumFacing)

        if (grimexploit) {
            PacketComponent.sendPacket(C06PacketPlayerPosLook(mc.thePlayer))
        }
        
        RotationComponent.setRotation(targetRotation,
            yawSpeed = RandomUtils.nextFloat(rotationYawSpeed.minimum, rotationYawSpeed.maximum),
            pitchSpeed = RandomUtils.nextFloat(rotationPitchSpeed.minimum, rotationPitchSpeed.maximum),
            speedMode = rotationSpeedMode,
            fixType = movementCorrection,
            ticks = resetTicks
        )
    }

    @EventHandler
    fun onMouse(event: MouseInputEvent) {
        mc.thePlayer ?: return

        //Switch Slot
        val blockSlot = findBlockForScaffoldInHotbar()
        if (blockSlot != -1)
            mc.thePlayer.inventory.currentItem = blockSlot - 36

        when (techniqueMode) {
            ProtectedSpawnTechnique, ExpandTechnique -> tryToPlace(blockPos, enumFacing, mc.objectMouseOver.hitVec)

            else -> if (mc.objectMouseOver.blockPos == blockPos && mc.objectMouseOver.sideHit == enumFacing) {
                tryToPlace(blockPos, enumFacing, mc.objectMouseOver.hitVec)
            }
        }
    }

    private fun findBlockForScaffoldInHotbar(): Int {
        val inventory = mc.thePlayer.openContainer
        var slot = -1
        var stackSize = -1

        val reachedSlotSize = if (switchOnOtherSlotIf == "StackSizeIsInReached") stackSizeToSwitchOnOtherSlot else 0

        for (idx in 36..44) {
            val stack = inventory.getSlot(idx).stack ?: continue
            val item = stack.item

            if (item is ItemBlock) {
                val block = item.block
                if (stack.stackSize > reachedSlotSize && block.isFullCube && block !in Constants.SCAFFOLD_BLOCK_BLACKLIST && block !is BlockBush) {
                    when (switchOnOtherSlotIf) {
                        "OtherSlotStackIsLargerThanIt" -> if (stack.stackSize > stackSize) {
                            slot = idx
                            stackSize = stack.stackSize
                        }
                        else -> slot = idx
                    }
                }
            }
        }

        return slot
    }

    private fun tryToPlace(blockPos: BlockPos, enumFacing: EnumFacing, vec: Vec3) {
        val currentItem = mc.thePlayer.inventory.currentItemStack
        val hitVec = when(techniqueMode){
            ExpandTechnique, ProtectedSpawnTechnique -> modifyVec(vec, enumFacing, Vec3(blockPos))
            else -> vec
        }

        if (mc.theWorld.getBlockState(blockPos).block.material != Material.air) {
            val initialStackSize = currentItem?.stackSize ?: 0

            if (mc.playerController.onPlayerRightClick(mc.thePlayer, mc.theWorld, currentItem, blockPos, enumFacing, hitVec)) {
                mc.thePlayer.swingItem()

                if(grimexploit) PacketComponent.sendPacket(C06PacketPlayerPosLook(mc.thePlayer))
                placedBlocksWithoutEagle++
            }

            if (currentItem != null) {
                if (currentItem.stackSize == 0) {
                    mc.thePlayer.inventory.mainInventory[mc.thePlayer.inventory.currentItem] = null
                } else if (currentItem.stackSize != initialStackSize) {
                    mc.entityRenderer.itemRenderer.resetEquippedProgress()
                }
            }
        }
    }

    @EventHandler
    fun onInput(event: MoveInputEvent) {
        if (waitForRotation) {
            if (RotationUtils.getRotationDifference(RotationComponent.tickRotation) > 1)
                startSneakTimer.reset()

            if (!startSneakTimer.hasTimePassed(startSneakDelay))
                event.sneak = true
        }

        val player = SimulatedPlayer.fromClientPlayer(mc.thePlayer.movementInput, false)
        player.tick()

        val collidingBox = mc.thePlayer.entityBoundingBox.addCoord(mc.thePlayer.motionX, mc.thePlayer.motionY, mc.thePlayer.motionZ).expand(-0.175, 0.0, -0.175)

        if (safeWalk.get() && mc.thePlayer.onGround && mc.theWorld.getCollidingBoundingBoxes(mc.thePlayer, collidingBox).isEmpty())
            event.sneak = true

        if (
            (techniqueMode == TellyTechnique || sameY == "Jump" || //Telly conditional
                    ((techniqueMode == GodBridgeTechnique ||
                            techniqueMode == WalkTechnique) && !player.onGround) // Walk / God contitional
        ) &&
            (mc.thePlayer.onGround && isMoving) //Jump conditional
        ){
            event.jump = true
        }
    }

    private val canSameY: Boolean
        get() = sameY != "Off" && !KeyBinding.keyBindJump.isKeyDown

    private fun calculateFacing(pos: BlockPos): Pair<BlockPos, EnumFacing>? {
        for ((offset, facing) in Constants.BLOCKFACINGS) {
            val checkPos = pos.add(offset)

            if (mc.theWorld.getBlockState(checkPos).block != Blocks.air)
                return checkPos to facing
        }

        return null
    }

    private fun clampHitVec(playerPos: Vec3, blockPos: BlockPos): Vec3 {
        val block = mc.theWorld.getBlockState(blockPos).block

        return Vec3(
            playerPos.xCoord.coerceIn(blockPos.x.toDouble(), blockPos.x.toDouble() + block.blockBoundsMaxX),
            playerPos.yCoord.coerceIn(blockPos.y.toDouble(), blockPos.y.toDouble() + block.blockBoundsMaxY),
            playerPos.zCoord.coerceIn(blockPos.z.toDouble(), blockPos.z.toDouble() + block.blockBoundsMaxZ)
        )
    }

    private fun modifyVec(original: Vec3, direction: EnumFacing, pos: Vec3): Vec3 {
        val x = original.xCoord
        val y = original.yCoord
        val z = original.zCoord

        val side = direction.opposite

        return when (side.axis) {
            EnumFacing.Axis.X -> Vec3(pos.xCoord + side.directionVec.x.coerceAtLeast(0), y, z)
            EnumFacing.Axis.Y -> Vec3(x, pos.yCoord + side.directionVec.y.coerceAtLeast(0), z)
            EnumFacing.Axis.Z -> Vec3(x, y, pos.zCoord + side.directionVec.z.coerceAtLeast(0))
        }
    }
}
