package net.bloom.bloomclient.features.module.modules.world

import net.bloom.bloomclient.event.EventState
import net.bloom.bloomclient.event.GameLoopEvent
import net.bloom.bloomclient.event.PacketEvent
import net.bloom.bloomclient.features.component.components.player.PacketComponent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement

object ModuleGhostBlock : Module(name = "GhostBlock", description = "", category = ModuleCategory.WORLD) {
    private val visibleLimit by int("VisibleLimit", 4, 0, 10)

    private var placedCount = 0
    private val clientPackets = mutableListOf<PacketEvent>()

    override fun onEnable() {
        placedCount = 0
    }

    override fun onDisable() {
        flushAllPackets()
    }

    private fun flushAllPackets() {
        synchronized(clientPackets) {
            while (clientPackets.isNotEmpty()) {
                val event = clientPackets.removeFirst()

                when(event.state){
                    EventState.SEND -> PacketComponent.sendPacketNoEvent(event.packet)
                    EventState.RECEIVE -> PacketComponent.processPacket(event.packet)
                }
            }
        }
    }

    @EventHandler
    fun onPacket(event: PacketEvent) {
        val packet = event.packet

        synchronized(clientPackets) {
            if (packet is C08PacketPlayerBlockPlacement) {
                if (placedCount++ < visibleLimit)
                    return
            }

            clientPackets.add(event)
            event.isCancelled = true
        }
    }

    @EventHandler
    fun onGameLoop(event: GameLoopEvent) {
        val player = mc.thePlayer ?: return

        if (player.isDead || player.ticksExisted <= 10) {
            flushAllPackets()
        }
    }
}
