package net.bloom.bloomclient.features.module.modules.world

import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.minecraft.item.ItemBlock
import net.minecraft.util.MovingObjectPosition


object ModuleFastPlace : Module(name = "FastPlace", description = "Allows you to place blocks faster.", category = ModuleCategory.WORLD) {
    val speedValue = int("Speed", 0, 0, 4)
    private val onlyBlocks = bool("OnlyBlocks", true)
    private val onlyWhenFacingBlocks = bool("OnlyWhenFacingBlocks", true)

    // Don't modify this
    fun canFastPlace(): Boolean {
        if (!state)
            return false

        if (onlyBlocks.get())
            return mc.thePlayer.inventory.currentItemStack?.item is ItemBlock

        if (onlyWhenFacingBlocks.get())
            return mc.objectMouseOver.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK

        return true
    }
}