package net.bloom.bloomclient.features.module.modules.render

import net.bloom.bloomclient.event.Render3DEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.utils.extension.*
import net.bloom.bloomclient.utils.render.GLUtils.glColor
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.general.GeneralOption
import net.minecraft.entity.Entity
import net.minecraft.entity.player.EntityPlayer
import net.minecraft.util.Vec3
import org.lwjgl.opengl.GL11.*
import java.awt.Color

object ModuleTracers : Module(
    category = ModuleCategory.RENDER,
    description = "Displays arrows to player",
    name = "Tracers",
) {
    private val thickness = float("Thickness", 2F, 1F, 5F)

    // Priority must be set lower than every other Listenable class that also listens to this event.
    // We re-apply camera transformation, which would affect NameTags if the priority was normal.
    @EventHandler(priority = -5)
    fun onRender3D(event: Render3DEvent) {
        mc.thePlayer ?: return

        val originalViewBobbing = GeneralOption.viewBobbing

        // Temporarily disable view bobbing and re-apply camera transformation
        GeneralOption.viewBobbing = false
        mc.entityRenderer.setupCameraTransform(mc.timer.renderPartialTicks, 0)

        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        glEnable(GL_BLEND)
        glEnable(GL_LINE_SMOOTH)
        glLineWidth(thickness.get())
        glDisable(GL_TEXTURE_2D)
        glDisable(GL_DEPTH_TEST)
        glDepthMask(false)

        glBegin(GL_LINES)

        val entities = mc.theWorld.loadedEntityList
            .filterIsInstance<EntityPlayer>()
            .filter { it != mc.thePlayer }
            .sortedBy { mc.thePlayer.eyes.distanceTo(it.positionVector) }
            .take(5)

        for (entity in entities) {
            val dist = mc.thePlayer.getDistanceSqToEntity(entity).coerceAtMost(255.0).toInt()
            val color = Color(255 - dist, dist, 0, 150)
            drawTraces(entity, color)
        }

        glEnd()

        GeneralOption.viewBobbing = originalViewBobbing

        glEnable(GL_TEXTURE_2D)
        glDisable(GL_LINE_SMOOTH)
        glEnable(GL_DEPTH_TEST)
        glDepthMask(true)
        glDisable(GL_BLEND)
        glColor4f(1f, 1f, 1f, 1f)
    }

    private fun drawTraces(entity: Entity, color: Color) {
        val player = mc.thePlayer ?: return

        val (x, y, z) = entity.interpolatedPosition(entity.lastTickPos, 0f) - mc.renderManager.renderPos

        val yaw = (player.lastPlayerYaw..player.playerYaw).lerpWith(mc.timer.renderPartialTicks)
        val pitch = (player.lastPlayerPitch..player.playerPitch).lerpWith(mc.timer.renderPartialTicks)

        val eyeVector = Vec3(0.0, 0.0, 1.0).rotatePitch(-pitch.toRadians()).rotateYaw(-yaw.toRadians())

        glColor(color)

        glVertex3d(eyeVector.xCoord, player.getEyeHeight() + eyeVector.yCoord, eyeVector.zCoord)
        glVertex3d(x, y, z)
        glVertex3d(x, y, z)
        glVertex3d(x, y + entity.height, z)
    }
}