package net.bloom.bloomclient.features.module.modules.render

import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.utils.player.EntityUtils
import net.minecraft.entity.Entity
import net.minecraft.entity.item.EntityArmorStand
import net.minecraft.entity.item.EntityItem
import net.minecraft.entity.player.EntityPlayer
import net.minecraft.entity.projectile.EntityArrow

object ModuleNoRender : Module(name = "NoRender", description = "No render", category = ModuleCategory.OTHER) {
    val waterOverlay = bool("WaterOverlay", true)
    val blockBreakParticles = bool("BlockBreakParticles", true)
    val lightningBolts = bool("LightingBolts", true)

    val isSnowball by bool("Snowball", true)
    val snowballTicks = int("SnowballRenderTicks", 2, 0, 20) { isSnowball }

    private val itemsValue by bool("Items", true)
    private val playersValue by bool("Players", true)
    private val mobsValue by bool("Mobs", true)
    private val animalsValue by bool("Animals", true)
    private val armorStandValue by bool("ArmorStand", true)
    private val maxRenderRange by float("MaxRenderRange", 4F, 0F, 16F, "m")
    val itemFrames = bool("ItemFrames", true)
    val mapItemFrames = bool("MapItemFrames", true)
    val enchantedBooks = bool("EnchantedBooks", true)
    val skulls = bool("Skulls", true)

    private val groundedArrows by bool("GroundedArrows", true)
    val attachedArrows = bool("AttachedArrows", true)
    private val movingArrows by bool("MovingArrows", true)
    val endPortals = bool("EndPortals", true)

    val potionEffects = bool("PotionEffects", true)

    fun shouldStopRender(entity: Entity): Boolean {
        return state && (itemsValue && entity is EntityItem
            || playersValue && entity is EntityPlayer
            || mobsValue && EntityUtils.isMob(entity)
            || animalsValue && EntityUtils.isAnimal(entity)
            || armorStandValue && entity is EntityArmorStand)
            && entity != mc.thePlayer
            && mc.thePlayer.getDistanceToEntityBox(entity).toFloat() > maxRenderRange
    }

    fun shouldStopRenderArrow(entity: EntityArrow): Boolean {
        val grounded = entity.inGround
        val moving = entity.motionX > 0 || entity.motionY > 0 || entity.motionZ > 0
        return state && (movingArrows && moving && !grounded || groundedArrows && grounded)
    }
}