package net.bloom.bloomclient.features.module.modules.render

import net.bloom.bloomclient.event.Render3DEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.utils.player.EntityUtils
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.entity.EntityLivingBase
import org.lwjgl.opengl.GL11

object ModuleNameTags: Module(
	name = "NameTags",
	description = "Display custom name tags.",
	category = ModuleCategory.RENDER
) {
	private val scaleValue = float("Scale", 1.0f, 1.0f, 4.0f)
	private val translateY = float("TranslateY", 0.55f, -2.0f, 2.0f)
	private val clearNamesValue = bool("ClearNames", false)

	private var targetTicks = 0
	private var entityKeep = "none"
	private val fontLexend = mc.minecraftFontRendererObj

	@EventHandler
	fun onRender3D(event: Render3DEvent) {
		mc.theWorld.loadedEntityList.forEach { entity ->
			if (EntityUtils.isSelected(entity, false) && !ModuleNoRender.shouldStopRender(entity)) {
				if (entity is EntityLivingBase) {
					val posX = interpolate(entity.posX, entity.lastTickPosX, event.partialTicks) - mc.renderManager.renderPosX
					val posY = interpolate(entity.posY + entity.eyeHeight + 0.5, entity.lastTickPosY + entity.eyeHeight + 0.5, event.partialTicks) - mc.renderManager.renderPosY
					val posZ = interpolate(entity.posZ, entity.lastTickPosZ, event.partialTicks) - mc.renderManager.renderPosZ
					renderNameTag(entity.name, posX, posY, posZ)
				}
			}
		}
	}
	private fun drawRect(left: Int, top: Int, right: Int, bottom: Int, color: Int) {
		net.minecraft.client.gui.Gui.drawRect(left, top, right, bottom, color)
	}
	private fun interpolate(current: Double, previous: Double, partialTicks: Float): Double {
		return previous + (current - previous) * partialTicks
	}
	private fun renderNameTag(name: String, x: Double, y: Double, z: Double) {
		val scale = 0.016f * 1.5f
		val viewerYaw = mc.renderManager.playerViewY
		val viewerPitch = mc.renderManager.playerViewX
		val fr = mc.minecraftFontRendererObj

		GL11.glPushMatrix()
		GL11.glTranslated(x, y, z)
		GL11.glNormal3f(0f, 1f, 0f)
		GL11.glRotatef(-viewerYaw, 0f, 1f, 0f)
		GL11.glRotatef(viewerPitch, 1f, 0f, 0f)
		GL11.glScalef(-scale, -scale, scale)

		GL11.glDisable(GL11.GL_LIGHTING)
		GL11.glDepthMask(false)
		GL11.glDisable(GL11.GL_DEPTH_TEST)
		GL11.glEnable(GL11.GL_BLEND)

		val width = fr.getStringWidth(name) / 2
		drawRect(-width - 2, -2, width + 2, 10, 0x55000000) // semi-transparent background

		fr.drawString(name, -width, 0, 0xFFFFFF)

		GL11.glEnable(GL11.GL_DEPTH_TEST)
		GL11.glDepthMask(true)
		GL11.glDisable(GL11.GL_BLEND)
		GL11.glEnable(GL11.GL_LIGHTING)
		GL11.glPopMatrix()
	}
}