package net.bloom.bloomclient.features.module.modules.render

import net.bloom.bloomclient.event.Render2DEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.GameStorage
import net.minecraft.client.option.options.general.GeneralOption

object ModuleMotionCamera : Module(
    name = "MotionCamera",
    description = "Adds camera smoothing and disables hurt camera shake.",
    category = ModuleCategory.RENDER,
) {
    val clipValue = bool("Clip", false)
    val smoothValue = bool("Motion", false)
    val bounceView = bool("BounceView", false)
    private val customYaw = float("BobChanger", 0.0F, 0.0F, 10.0F)

    private var shouldSmooth = false
    private var previousFov = 0
    private var currentFov = 0

    @EventHandler
    fun onRender2D(event: Render2DEvent) {
        if (bounceView.get()) {

            if (GameStorage.thirdPersonView == 0) {
                if (shouldSmooth && GeneralOption.fOV != previousFov)
                    GeneralOption.fOV = previousFov

                shouldSmooth = false
                return
            }

            if (!shouldSmooth) {
                previousFov = GeneralOption.fOV
                currentFov = -10
                shouldSmooth = true
            }

            currentFov = if (mc.currentScreen == null) {
                currentFov + (previousFov - currentFov) / 10
            } else {
                previousFov
            }

            GeneralOption.fOV = currentFov.coerceIn(0, previousFov)
        }

        val player = mc.thePlayer

        if (player != null && player.onGround)
            player.cameraYaw = customYaw.get()
    }
}
