package net.bloom.bloomclient.features.module.modules.render

import net.bloom.bloomclient.event.UpdateEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.potion.Potion
import net.minecraft.potion.PotionEffect
import net.minecraft.server.MinecraftServer
import net.minecraft.src.Config

object ModuleFullBright : Module(name = "FullBright", description = "", category = ModuleCategory.RENDER) {

    val mode by list("Mode", "Gamma", arrayOf("Gamma", "NightVision", "Patcher"))
    private val noFullbrightIfMinecraftUsingShader = bool("NoFullbrightIfMinecraftIsUsingShader", true) { mode.equals("patcher", true) }

    override fun onDisable() {
        if (mc.thePlayer != null)
            mc.thePlayer.removePotionEffectClient(Potion.nightVision.id)
    }

    override fun onShutdown() {
        onDisable()
    }

    @EventHandler
    fun onUpdate(event: UpdateEvent) {
        if (mode.equals("nightvision", true))
            mc.thePlayer.addPotionEffect(PotionEffect(Potion.nightVision.id, 1337, 1))
    }

    @JvmStatic
    fun canUseFullbright(): Boolean {
        val minecraftServer = MinecraftServer.getServer()

        if (minecraftServer != null && minecraftServer.isCallingFromMinecraftThread)
            return false

        return state && mode.equals("patcher", true) && noFullbrightIfMinecraftUsingShader.get() && !Config.isShaders()
    }

    override val tag: String
        get() = mode

}