package net.bloom.bloomclient.features.module.modules.render

import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.bloom.bloomclient.utils.Constants.MODIFIER_BY_TICK
import net.minecraft.entity.player.EntityPlayer
import net.minecraft.init.Items
import net.minecraft.potion.Potion
import kotlin.math.min


object ModuleFOVModifier : Module(
    category = ModuleCategory.RENDER,
    description = "Customize FOV for some actions",
    name = "FOVModifier",
) {
    private val sprintFOV = float("SprintFOV", 1f, -5f, 5f)
    private val speedFOV = float("SpeedFOV", 1f, -5f, 5f)
    private val slownessFOV = float("SlownessFOV", 1f, -5f, 5f)
    private val bowFOV = float("BowFOV", 1f, -5f, 5f)

    fun getFOVModifier(currentFOV: Float, entity: EntityPlayer): Float {

        var f = currentFOV
        val item = entity.itemInUse
        val useDuration = entity.itemInUseDuration

        val sprintingFov = sprintFOV.get()
        val bowFov = bowFOV.get()
        val speedFov = speedFOV.get()
        val slownessFov = slownessFOV.get()

        if (entity.isSprinting)
            f += 0.15000000596046448f * sprintingFov

        if (item != null && item.item === Items.bow) {
            val duration = min(useDuration.toFloat(), 20.0f).toInt()
            val modifier = MODIFIER_BY_TICK[duration] ?: 0f
            f -= modifier * bowFov
        }

        val effects = entity.activePotionEffects
        for (effect in effects) {
            val potionID = effect.potionID
            if (potionID == Potion.moveSpeed.id)
                f += 0.1f * (effect.amplifier + 1) * speedFov

            if (potionID == Potion.moveSlowdown.id)
                f += -0.075f * (effect.amplifier + 1) * slownessFov
        }

        return f

    }
}