package net.bloom.bloomclient.features.module.modules.render

import net.bloom.bloomclient.event.ReceivedPacketEvent
import net.bloom.bloomclient.features.module.Module
import net.bloom.bloomclient.features.module.ModuleCategory
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.network.play.server.S3FPacketCustomPayload

object ModuleAntiBlind : Module(
    name = "AntiBlind",
    description = "Make you not be blinded by conditions.",
    category = ModuleCategory.RENDER
) {
    val confusionEffect = bool("Confusion", true)
    val pumpkinEffect = bool("Pumpkin", true)
    val bossHealth = bool("BossHealth", true)
    private val bookPage = bool("BookPage", true)
    val achievements = bool("Achievements", true)

    @EventHandler
    fun onPacket(event: ReceivedPacketEvent){
        if (!bookPage.get())
            return

        val packet = event.packet
        if (packet is S3FPacketCustomPayload && packet.channelName == "MC|BOpen")
            event.isCancelled = true
    }
}