package net.bloom.bloomclient.features.module.modules.player.nofall

import net.bloom.bloomclient.event.PostStrafeEvent
import net.bloom.bloomclient.event.PreMotionEvent
import net.bloom.bloomclient.features.component.components.player.PacketComponent
import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.utils.struct.TickTimer
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.network.play.client.C03PacketPlayer

/**
 * Concept: Send C03 packet and freeze. This method makes Matrix think we are on ground.
 * @author toidicakhia
 */
object Matrix7NoFall: Mode("Matrix7") {
    private val fallDistance by float("FallDistance", 2.6f, 1f, 20f)
    private val freezeTicks by int("FreezeTicks", 10, 0, 50)

    private var freeze = false
    private var tickTimer = TickTimer()

    override fun onEnable() {
        freeze = false
        tickTimer.reset()
    }

    @EventHandler
    fun onPostStrafe(event: PostStrafeEvent) {
        if (!freeze && mc.thePlayer.fallDistance > fallDistance) {
            PacketComponent.sendPacket(C03PacketPlayer(true))
            mc.thePlayer.fallDistance = 0.0f
            freeze = true
        }

        if (freeze) {
            mc.thePlayer.motionX = 0.0
            mc.thePlayer.motionZ = 0.0
            mc.thePlayer.motionY = 0.0

            tickTimer.waitTicks(freezeTicks) { freeze = false }
        }
    }

    @EventHandler
    fun onPreMotion(event: PreMotionEvent) {
        if (freeze)
            event.isCancelled = true
    }
}