package net.bloom.bloomclient.features.module.modules.player.nofall

import net.bloom.bloomclient.event.MoveInputEvent
import net.bloom.bloomclient.event.PreMotionEvent
import net.bloom.bloomclient.event.PreUpdateEvent
import net.bloom.bloomclient.event.ReceivedPacketEvent
import net.bloom.bloomclient.features.component.components.player.PacketComponent
import net.bloom.bloomclient.features.component.components.player.PacketComponent.sendPacket
import net.bloom.bloomclient.features.mode.Mode
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.network.Packet
import net.minecraft.network.play.INetHandlerPlayClient
import net.minecraft.network.play.client.C03PacketPlayer
import net.minecraft.network.play.server.S00PacketKeepAlive
import net.minecraft.network.play.server.S12PacketEntityVelocity
import net.minecraft.network.play.server.S32PacketConfirmTransaction


object Grim19NoFall: Mode("Grim1.9") {

    private var shouldFall = false
    private var hasVelocity = false
    private var shouldJump = false
    private var doCancelPacket = false

    private val packets = mutableListOf<Packet<INetHandlerPlayClient>>()

    @EventHandler(priority = 2)
    fun onReceivedPacket(event: ReceivedPacketEvent) {
        if (!shouldFall && mc.thePlayer.ticksExisted >= 10 && !mc.thePlayer.isCollidedHorizontally) {
            when (val packet = event.packet) {
                is S12PacketEntityVelocity -> {
                    if (packet.entityID == mc.thePlayer.entityId && !event.isCancelled) {
                        if (packet.motionY > 0 || mc.thePlayer.ticksSinceVelocity <= 14 || mc.thePlayer.onGroundTicks <= 1) {
                            hasVelocity = true
                        }

                        if (!mc.thePlayer.onGround && shouldJump) {
                            doCancelPacket = true
                            packets.add(packet)
                            event.isCancelled = true
                        }
                    }
                }

                is S32PacketConfirmTransaction -> if (doCancelPacket) {
                    event.isCancelled = true
                    packets.add(packet)
                }

                is S00PacketKeepAlive -> if (doCancelPacket) {
                    event.isCancelled = true
                    packets.add(packet)
                }
            }
        }
    }

    @EventHandler
    fun onPreMotion(event: PreMotionEvent) {
        if (!mc.thePlayer.isCollidedHorizontally) {
            if (mc.thePlayer.motionY > 0.1)
                shouldJump = false

            if (mc.thePlayer.fallDistance > 3.0f)
                shouldJump = true

            if (shouldJump && mc.thePlayer.onGround) {
                event.isCancelled = true
                sendPacket(C03PacketPlayer(true))
                KeyBinding.keyBindJump.isKeyDown = false
            }

            if (shouldJump)
                KeyBinding.keyBindJump.isKeyDown = false
        }
    }

    @EventHandler(priority = 2)
    fun onPreUpdate(event: PreUpdateEvent) {
        if (doCancelPacket && mc.thePlayer.onGround) {
            shouldFall = true
            doCancelPacket = false
            packets.forEach { PacketComponent.processPacket(it) }
            packets.clear()
            shouldFall = false
        }
    }

    @EventHandler
    fun onMoveInput(event: MoveInputEvent) {
        if (!mc.thePlayer.isCollidedHorizontally) {
            if (hasVelocity && shouldJump) {
                event.jump = true
                hasVelocity = false
            }
        }
    }

    override fun onEnable() {
        shouldJump = false
    }
}