package net.bloom.bloomclient.features.module.modules.player.autofood

import net.bloom.bloomclient.event.MouseInputEvent
import net.bloom.bloomclient.event.PreMotionEvent
import net.bloom.bloomclient.event.UpdateEvent
import net.bloom.bloomclient.features.component.components.player.PacketComponent.sendPacket
import net.bloom.bloomclient.features.mode.Mode
import net.bloom.bloomclient.features.module.modules.player.ModuleAutoFood
import net.bloom.bloomclient.features.module.modules.player.ModuleAutoFood.msTimer
import net.lenni0451.lambdaevents.EventHandler
import net.minecraft.client.option.options.devices.KeyBinding
import net.minecraft.network.play.client.C03PacketPlayer
import net.minecraft.network.play.client.C03PacketPlayer.*
import net.minecraft.network.play.client.C07PacketPlayerDigging
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement
import net.minecraft.network.play.client.C09PacketHeldItemChange
import net.minecraft.util.BlockPos
import net.minecraft.util.EnumFacing

object PacketAutoFoodMode: Mode("Packet") {
    private val packetType by list("Packet", "C03", arrayOf("C03", "C04", "C05", "C06"))
    private val packetAmount by int("PacketAmount", 1, 1, 100)

    @EventHandler
    fun onMouse(event: PreMotionEvent) {
        if (!ModuleAutoFood.canFood())
            return

        val data = ModuleAutoFood.findFood() ?: return
        val slot = data.slot - 36

        sendPacket(C09PacketHeldItemChange(slot))
        sendPacket(C08PacketPlayerBlockPlacement(data.itemStack))
        repeat (packetAmount) {
            when (packetType.lowercase()) {
                "c04" -> sendPacket(C04PacketPlayerPosition(mc.thePlayer))
                "c05" -> sendPacket(C05PacketPlayerLook(mc.thePlayer))
                "c06" -> sendPacket(C06PacketPlayerPosLook(mc.thePlayer))
                else -> sendPacket(C03PacketPlayer(mc.thePlayer.onGround))
            }
        }

        sendPacket(C09PacketHeldItemChange(mc.thePlayer.inventory.currentItem))
        msTimer.reset()
    }
}

object LegitAutoFoodMode: Mode("Legit") {
    private var prevSlot = -1
    private var slotAmount = -1

    override fun onEnable() {
        prevSlot = -1
        slotAmount = -1
    }

    override fun onDisable() {
        KeyBinding.keyBindUseItem.isKeyDown = KeyBinding.isKeyDown(KeyBinding.keyBindUseItem)
    }

    @EventHandler
    fun onUpdate(event: UpdateEvent) {
        mc.thePlayer ?: return

        if (prevSlot >= 0) {
            if (mc.thePlayer.absorptionAmount > 0) {
                KeyBinding.keyBindUseItem.isKeyDown = false
                mc.thePlayer.inventory.currentItem = prevSlot
                prevSlot = -1
                msTimer.reset()
            } else {
                KeyBinding.keyBindUseItem.isKeyDown = true
            }

            return
        }

        if (!ModuleAutoFood.canFood())
            return

        val data = ModuleAutoFood.findFood() ?: return

        prevSlot = mc.thePlayer.inventory.currentItem
        mc.thePlayer.inventory.currentItem = data.slot - 36
        slotAmount = data.itemStack.stackSize
    }
}